/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.web.struts;

import java.util.HashSet;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.tiles.ComponentContext;
import org.apache.struts.tiles.actions.TilesAction;
import org.intermine.api.InterMineAPI;
import org.intermine.api.profile.InterMineBag;
import org.intermine.api.tag.AspectTagUtil;
import org.intermine.api.template.TemplateManager;
import org.intermine.metadata.ClassDescriptor;
import org.intermine.metadata.Model;
import org.intermine.metadata.Util;
import org.intermine.web.logic.results.ReportObject;
import org.intermine.web.logic.session.SessionMethods;

public class TemplateListController
extends TilesAction {
    private static final Logger LOG = Logger.getLogger(TemplateListController.class);

    public ActionForward execute(ComponentContext context, ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        InterMineAPI im = SessionMethods.getInterMineAPI(request.getSession());
        Model model = im.getModel();
        String scope = (String)context.getAttribute("scope");
        String aspect = (String)context.getAttribute("placement");
        ReportObject object = (ReportObject)context.getAttribute("reportObject");
        if (AspectTagUtil.isAspectTag((String)aspect)) {
            aspect = AspectTagUtil.getAspect((String)aspect);
        }
        InterMineBag interMineIdBag = (InterMineBag)context.getAttribute("interMineIdBag");
        List templates = null;
        TemplateManager templateManager = im.getTemplateManager();
        HashSet<String> allClasses = new HashSet<String>();
        if (StringUtils.equals((String)"global", (String)scope)) {
            if (interMineIdBag != null) {
                for (ClassDescriptor cld : interMineIdBag.getClassDescriptors()) {
                    allClasses.add(cld.getUnqualifiedName());
                }
                templates = templateManager.getReportPageTemplatesForAspect(aspect, allClasses);
            } else if (object != null) {
                ClassDescriptor thisCld = model.getClassDescriptorByName(Util.getFriendlyName(object.getObject().getClass()));
                for (ClassDescriptor cld : model.getClassDescriptorsForClass(thisCld.getType())) {
                    allClasses.add(cld.getUnqualifiedName());
                }
                templates = templateManager.getReportPageTemplatesForAspect(aspect, allClasses);
            } else {
                templates = templateManager.getAspectTemplates(aspect);
            }
        } else if (StringUtils.equals((String)"user", (String)scope)) {
            // empty if block
        }
        request.setAttribute("templates", (Object)templates);
        return null;
    }
}

