/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.web.struts;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.intermine.api.InterMineAPI;
import org.intermine.api.bag.BagManager;
import org.intermine.api.profile.Profile;
import org.intermine.api.template.TemplateHelper;
import org.intermine.template.TemplateQuery;
import org.intermine.template.xml.TemplateQueryBinding;
import org.intermine.web.logic.session.SessionMethods;
import org.intermine.web.struts.ImportXMLForm;

public class TemplatesImportForm
extends ImportXMLForm {
    private boolean overwriting = false;
    private boolean deleteTracks = false;
    private Map<String, TemplateQuery> map;

    public boolean isOverwriting() {
        return this.overwriting;
    }

    public void setOverwriting(boolean overwriting) {
        this.overwriting = overwriting;
    }

    public boolean isDeleteTracks() {
        return this.deleteTracks;
    }

    public void setDeleteTracks(boolean deleteTracks) {
        this.deleteTracks = deleteTracks;
    }

    @Override
    protected void reset() {
        super.reset();
        this.overwriting = false;
        this.deleteTracks = false;
    }

    public ActionErrors validate(ActionMapping mapping, HttpServletRequest request) {
        HttpSession session = request.getSession();
        InterMineAPI im = SessionMethods.getInterMineAPI(session);
        Profile profile = SessionMethods.getProfile(session);
        BagManager bagManager = im.getBagManager();
        ActionErrors errors = super.validate(mapping, request);
        if (errors != null && errors.size() > 0) {
            return errors;
        }
        if (this.formFile != null && this.formFile.getFileName() != null && this.formFile.getFileName().length() > 0) {
            String mimetype = this.formFile.getContentType();
            if (!"application/octet-stream".equals(mimetype) && !mimetype.startsWith("text")) {
                errors.add("org.apache.struts.action.GLOBAL_MESSAGE", new ActionMessage("importTemplates.notText", (Object)mimetype));
                return errors;
            }
            if (this.formFile.getFileSize() == 0) {
                errors.add("org.apache.struts.action.GLOBAL_MESSAGE", new ActionMessage("importTemplates.noTemplateFileOrEmpty"));
                return errors;
            }
        }
        try {
            this.xml = this.xml.trim();
            if (!this.xml.isEmpty()) {
                Map allBags = bagManager.getBags(profile);
                TemplateHelper.xmlToTemplateMap((String)this.getXml(), (Map)allBags, (int)2);
            } else if (this.formFile != null) {
                BufferedReader reader = new BufferedReader(new InputStreamReader(this.formFile.getInputStream()));
                this.map = TemplateQueryBinding.unmarshalTemplates((Reader)reader, (int)2);
            }
        }
        catch (Exception err) {
            if (errors == null) {
                errors = new ActionErrors();
            }
            errors.add("org.apache.struts.action.GLOBAL_MESSAGE", new ActionMessage("errors.badtemplatexml", (Object)err.getMessage()));
        }
        return errors;
    }

    public Map<String, TemplateQuery> getQueryMap(BagManager bagManager, Profile profile) throws Exception {
        Map allBags = bagManager.getBags(profile);
        if (this.map == null) {
            this.xml = this.xml.trim();
            if (!this.xml.isEmpty()) {
                if (!this.xml.startsWith("<templates>")) {
                    this.xml = "<templates>" + this.xml + "</templates>";
                }
                this.map = TemplateHelper.xmlToTemplateMap((String)this.getXml(), (Map)allBags, (int)2);
            } else if (this.formFile != null) {
                BufferedReader reader = new BufferedReader(new InputStreamReader(this.formFile.getInputStream()));
                this.map = TemplateQueryBinding.unmarshalTemplates((Reader)reader, (int)2);
            }
        }
        return this.map;
    }
}

