/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.web.struts;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.tiles.ComponentContext;
import org.apache.struts.tiles.actions.TilesAction;
import org.intermine.api.InterMineAPI;
import org.intermine.metadata.ClassDescriptor;
import org.intermine.metadata.Model;
import org.intermine.web.logic.TreeNode;
import org.intermine.web.logic.session.SessionMethods;

public class TreeController
extends TilesAction {
    public ActionForward execute(ComponentContext context, ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession();
        InterMineAPI im = SessionMethods.getInterMineAPI(session);
        HashSet<String> openClasses = (HashSet<String>)session.getAttribute("openClasses");
        if (openClasses == null) {
            openClasses = new HashSet<String>();
            openClasses.add("org.intermine.model.InterMineObject");
            session.setAttribute("openClasses", openClasses);
        }
        ServletContext servletContext = session.getServletContext();
        Model model = im.getModel();
        String rootClass = (String)request.getAttribute("rootClass");
        ArrayList<ClassDescriptor> rootClasses = new ArrayList<ClassDescriptor>();
        if (rootClass != null) {
            rootClasses.add(model.getClassDescriptorByName(rootClass));
        } else {
            rootClass = "org.intermine.model.InterMineObject";
            rootClasses.add(model.getClassDescriptorByName(rootClass));
            for (ClassDescriptor cld : model.getClassDescriptors()) {
                if (!cld.getSuperDescriptors().isEmpty() || "org.intermine.model.InterMineObject".equals(cld.getName())) continue;
                rootClasses.add(cld);
            }
        }
        Map classCounts = (Map)servletContext.getAttribute("classCounts");
        ArrayList<TreeNode> nodes = new ArrayList<TreeNode>();
        List<String> empty = Collections.emptyList();
        Iterator cldIter = rootClasses.iterator();
        while (cldIter.hasNext()) {
            ClassDescriptor cld = (ClassDescriptor)cldIter.next();
            nodes.addAll(this.makeNodes(cld, openClasses, 0, classCounts, empty, !cldIter.hasNext()));
        }
        context.putAttribute("nodes", nodes);
        return null;
    }

    protected List<TreeNode> makeNodes(ClassDescriptor parent, Set<String> openClasses, int depth, Map<?, ?> classCounts, List<String> structure, boolean last) {
        ArrayList<String> newStructure = new ArrayList<String>(structure);
        if (last) {
            newStructure.add("ell");
        } else {
            newStructure.add("tee");
        }
        newStructure.remove(0);
        ArrayList<TreeNode> nodes = new ArrayList<TreeNode>();
        nodes.add(new TreeNode(parent, classCounts.get(parent.getName()).toString(), depth, false, parent.getSubDescriptors().size() == 0, openClasses.contains(parent.getName()), newStructure));
        newStructure = new ArrayList<String>(structure);
        if (last) {
            newStructure.add("blank");
        } else {
            newStructure.add("straight");
        }
        if (openClasses.contains(parent.getName())) {
            TreeSet<ClassDescriptor> sortedClds = new TreeSet<ClassDescriptor>(new Comparator<ClassDescriptor>(){

                @Override
                public int compare(ClassDescriptor c1, ClassDescriptor c2) {
                    return c1.getName().compareTo(c2.getName());
                }
            });
            sortedClds.addAll(parent.getSubDescriptors());
            Iterator cldIter = sortedClds.iterator();
            while (cldIter.hasNext()) {
                ClassDescriptor cld = (ClassDescriptor)cldIter.next();
                nodes.addAll(this.makeNodes(cld, openClasses, depth + 1, classCounts, newStructure, !cldIter.hasNext()));
            }
        }
        return nodes;
    }
}

