/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.web.struts;

import java.io.PrintWriter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.intermine.api.profile.BagValue;
import org.intermine.api.profile.Profile;
import org.intermine.api.profile.StorableBag;
import org.intermine.web.logic.session.SessionMethods;
import org.intermine.web.struts.ForwardParameters;
import org.intermine.web.struts.InterMineAction;
import org.intermine.web.struts.TriageBagForm;

public class TriageBagAction
extends InterMineAction {
    private static final Logger LOG = Logger.getLogger(TriageBagAction.class);

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        TriageBagForm tbf = (TriageBagForm)form;
        String[] selectedBagNames = tbf.getSelectedBags();
        HttpSession session = request.getSession();
        Profile profile = SessionMethods.getProfile(session);
        if (selectedBagNames.length == 0) {
            this.recordError(new ActionMessage("errors.bag.listnotselected"), request);
            return this.getReturn(tbf.getPageName(), mapping);
        }
        if (request.getParameter("export") != null || tbf.getListsButton() != null && "export".equals(tbf.getListsButton())) {
            String bagName = this.getBagName(tbf.getSelectedBags());
            response.setContentType("text/plain");
            response.setHeader("Content-Disposition ", "attachment; filename=" + bagName + ".tsv");
            PrintWriter writer = response.getWriter();
            for (String name : tbf.getSelectedBags()) {
                StorableBag s = (StorableBag)profile.getAllBags().get(name);
                writer.println("# CONTENTS OF: " + name + " (" + s.getDescription() + ")");
                for (BagValue bv : s.getContents()) {
                    writer.println(bv.getValue() + "\t" + bv.getExtra());
                }
            }
            writer.flush();
            return null;
        }
        if (request.getParameter("delete") != null || tbf.getListsButton() != null && "delete".equals(tbf.getListsButton())) {
            for (String name : tbf.getSelectedBags()) {
                profile.deleteBag(name);
            }
        } else {
            LOG.error((Object)("Nothing done! listsButton='" + tbf.getListsButton() + "'"));
        }
        return this.getReturn(tbf.getPageName(), mapping);
    }

    private String getBagName(String[] names) {
        if (names.length == 1) {
            return names[0];
        }
        return StringUtils.join((Object[])names, (String)"+");
    }

    private ActionForward getReturn(String pageName, ActionMapping mapping) {
        if (pageName != null && "MyMine".equals(pageName)) {
            return new ForwardParameters(mapping.findForward("mymine")).addParameter("subtab", "lists").forward();
        }
        return new ForwardParameters(mapping.findForward("bag")).addParameter("subtab", "view").forward();
    }
}

