/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.web.struts;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.tiles.ComponentContext;
import org.apache.struts.tiles.actions.TilesAction;
import org.intermine.api.InterMineAPI;
import org.intermine.api.profile.InterMineBag;
import org.intermine.api.profile.Profile;
import org.intermine.api.profile.ProfileManager;
import org.intermine.api.profile.TagManager;
import org.intermine.api.search.SearchFilterEngine;
import org.intermine.api.search.SearchRepository;
import org.intermine.api.search.SearchResults;
import org.intermine.api.search.WebSearchable;
import org.intermine.api.template.TemplateManager;
import org.intermine.api.userprofile.Tag;
import org.intermine.metadata.StringUtil;
import org.intermine.objectstore.query.ObjectStoreBag;
import org.intermine.web.logic.WebUtil;
import org.intermine.web.logic.session.SessionMethods;
import org.stringtree.json.JSONWriter;

public class WebSearchableListController
extends TilesAction {
    private static final Logger LOG = Logger.getLogger(WebSearchableListController.class);
    private InterMineAPI im;
    private static TagManager tagManager;

    public ActionForward execute(ComponentContext context, ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String type = (String)context.getAttribute("type");
        String scope = (String)context.getAttribute("scope");
        String tags = (String)context.getAttribute("tags");
        String list = (String)context.getAttribute("list");
        String limit = (String)context.getAttribute("limit");
        String templatesPublicPage = (String)context.getAttribute("templatesPublicPage");
        Map<String, WebSearchable> filteredWebSearchables = new HashMap<String, WebSearchable>();
        HttpSession session = request.getSession();
        this.im = SessionMethods.getInterMineAPI(session);
        tagManager = this.im.getTagManager();
        if (type.equals("bag") && this.im.getBagManager().isAnyBagToUpgrade(SessionMethods.getProfile(session))) {
            ActionMessages actionErrors = this.getErrors(request);
            actionErrors.add("org.apache.struts.action.GLOBAL_MESSAGE", new ActionMessage("login.upgradeListManually"));
            this.saveErrors(request, actionErrors);
        }
        if (scope.equals("all")) {
            Map<String, ? extends WebSearchable> globalWebSearchables = WebSearchableListController.getFilterWebSearchables(request, type, "global", tags);
            Map<String, ? extends WebSearchable> userWebSearchables = WebSearchableListController.getFilterWebSearchables(request, type, "user", tags);
            filteredWebSearchables.putAll(userWebSearchables);
            filteredWebSearchables.putAll(globalWebSearchables);
        } else {
            filteredWebSearchables.putAll(WebSearchableListController.getFilterWebSearchables(request, type, scope, tags));
        }
        if (list != null) {
            filteredWebSearchables = WebSearchableListController.filterByList(filteredWebSearchables, list);
        }
        if (type.equals("bag")) {
            filteredWebSearchables = this.filterByCurrent(filteredWebSearchables);
        }
        int limitInt = 0;
        if (limit != null) {
            try {
                limitInt = new Integer(limit.trim());
            }
            catch (NumberFormatException userWebSearchables) {
                // empty catch block
            }
        }
        filteredWebSearchables = limitInt > 0 ? WebUtil.shuffle(filteredWebSearchables, limitInt) : ("true".equals(templatesPublicPage) ? this.sortListByMostPopular(filteredWebSearchables, session) : this.sortList(filteredWebSearchables));
        HashMap<String, Integer> wsMapForJS = new HashMap<String, Integer>();
        SearchResults.filterOutInvalidTemplates(filteredWebSearchables);
        for (String wsName : filteredWebSearchables.keySet()) {
            wsMapForJS.put(wsName, new Integer(1));
        }
        Profile profile = SessionMethods.getProfile(session);
        request.setAttribute("userWebSearchables", (Object)profile.getWebSearchablesByType(type));
        request.setAttribute("filteredWebSearchables", filteredWebSearchables);
        if (type.equals("bag")) {
            ProfileManager pm = profile.getProfileManager();
            Map sharedBags = profile.getSharedBags();
            HashMap<String, String> sharedBagsByOwner = new HashMap<String, String>();
            for (Map.Entry entry : sharedBags.entrySet()) {
                int id = ((InterMineBag)entry.getValue()).getProfileId();
                Profile owner = pm.getProfile(id);
                sharedBagsByOwner.put((String)entry.getKey(), owner.getName());
            }
            request.setAttribute("sharedBagWebSearchables", sharedBagsByOwner);
        }
        JSONWriter jsonWriter = new JSONWriter();
        request.setAttribute("wsNames", (Object)jsonWriter.write(wsMapForJS));
        return null;
    }

    private Map<String, WebSearchable> sortList(final Map<String, WebSearchable> filteredWebSearchables) {
        Comparator<String> comparator = new Comparator<String>(){

            private List<Tag> resolveTagsInBag(InterMineBag bag) {
                List tags = tagManager.getTags(null, bag.getName(), "bag", null);
                return tags;
            }

            private Integer resolveOrderFromTagsList(List<Tag> tags) {
                for (Tag t : tags) {
                    String name = t.getTagName();
                    if (!name.startsWith("im:order:")) continue;
                    return Integer.parseInt(name.replaceAll("[^0-9]", ""));
                }
                return 666;
            }

            @Override
            public int compare(String o1, String o2) {
                WebSearchable ws1 = (WebSearchable)filteredWebSearchables.get(o1);
                WebSearchable ws2 = (WebSearchable)filteredWebSearchables.get(o2);
                if (ws1 instanceof InterMineBag && ws2 instanceof InterMineBag) {
                    InterMineBag bag1 = (InterMineBag)ws1;
                    InterMineBag bag2 = (InterMineBag)ws2;
                    return this.compareBags(bag1, bag2);
                }
                if (ws1.getTitle().equals(ws2.getTitle())) {
                    return this.compareByName(ws1, ws2);
                }
                return ws1.getTitle().compareTo(ws2.getTitle());
            }

            private int compareBags(InterMineBag bag1, InterMineBag bag2) {
                Integer aO = this.resolveOrderFromTagsList(this.resolveTagsInBag(bag1));
                Integer bO = this.resolveOrderFromTagsList(this.resolveTagsInBag(bag2));
                if (aO < bO) {
                    return -1;
                }
                if (aO > bO) {
                    return 1;
                }
                if (bag1.getDateCreated() != null && bag2.getDateCreated() != null) {
                    if (!bag1.getDateCreated().equals(bag2.getDateCreated())) {
                        return bag2.getDateCreated().compareTo(bag1.getDateCreated());
                    }
                    return this.compareByName((WebSearchable)bag1, (WebSearchable)bag2);
                }
                return this.compareByName((WebSearchable)bag1, (WebSearchable)bag2);
            }

            private int compareByName(WebSearchable ws1, WebSearchable ws2) {
                if (!ws1.getName().equals(ws2.getName())) {
                    return ws1.getName().compareTo(ws2.getName());
                }
                return 1;
            }
        };
        TreeMap<String, WebSearchable> sortedMap = new TreeMap<String, WebSearchable>(comparator);
        sortedMap.putAll(filteredWebSearchables);
        if (filteredWebSearchables.size() != sortedMap.size()) {
            LOG.error((Object)"Important error. Sorting of web searchables removed some items.");
        }
        return sortedMap;
    }

    private Map<String, WebSearchable> sortListByMostPopular(Map<String, WebSearchable> filteredWebSearchables, HttpSession session) {
        TemplateManager tm = this.im.getTemplateManager();
        Profile profile = SessionMethods.getProfile(session);
        List mostPopulareTemplateNames = profile.isLoggedIn() ? tm.getMostPopularTemplateOrder(profile.getUsername(), session.getId(), null) : tm.getMostPopularTemplateOrder(null);
        if (mostPopulareTemplateNames == null) {
            return this.sortList(filteredWebSearchables);
        }
        MostPopularTemplateComparator comparator = new MostPopularTemplateComparator(mostPopulareTemplateNames, filteredWebSearchables);
        TreeMap<String, WebSearchable> sortedMap = new TreeMap<String, WebSearchable>(comparator);
        sortedMap.putAll(filteredWebSearchables);
        if (filteredWebSearchables.size() != sortedMap.size()) {
            LOG.error((Object)"Important error.Sorting of web searchables by most popular removed some items.");
        }
        return sortedMap;
    }

    public static Map<String, ? extends WebSearchable> getFilterWebSearchables(HttpServletRequest request, String type, String scope, String tags) {
        Map webSearchables;
        HttpSession session = request.getSession();
        InterMineAPI im = SessionMethods.getInterMineAPI(session);
        ServletContext servletContext = session.getServletContext();
        Profile profile = scope.equals("global") ? im.getProfileManager().getSuperuserProfile() : SessionMethods.getProfile(session);
        SearchRepository searchRepository = scope.equals("global") ? SessionMethods.getGlobalSearchRepository(servletContext) : profile.getSearchRepository();
        Map filteredWebSearchables = webSearchables = searchRepository.getWebSearchableMap(type);
        if (tags != null && tags.length() > 0) {
            List<String> tagList = Arrays.asList(StringUtil.split((String)tags.trim(), (String)" "));
            filteredWebSearchables = new SearchFilterEngine().filterByTags(filteredWebSearchables, tagList, type, profile.getUsername(), tagManager, false);
        }
        return filteredWebSearchables;
    }

    public static Map<String, WebSearchable> filterByList(Map<String, WebSearchable> filteredWebSearchables, String list) {
        HashMap<String, WebSearchable> clone = new HashMap<String, WebSearchable>();
        clone.putAll(filteredWebSearchables);
        String tmp = list.replaceAll(" ", "");
        String[] s = tmp.split(",");
        HashSet<String> set = new HashSet<String>();
        set.addAll(Arrays.asList(s));
        for (WebSearchable o : filteredWebSearchables.values()) {
            InterMineBag bag = (InterMineBag)o;
            ObjectStoreBag osb = bag.getOsb();
            Integer i = new Integer(osb.getBagId());
            if (set.contains(i.toString())) continue;
            clone.remove(bag.getName());
        }
        return clone;
    }

    private Map<String, WebSearchable> filterByCurrent(Map<String, WebSearchable> filteredWebSearchables) {
        HashMap<String, WebSearchable> clone = new HashMap<String, WebSearchable>();
        clone.putAll(filteredWebSearchables);
        for (WebSearchable o : filteredWebSearchables.values()) {
            InterMineBag bag = (InterMineBag)o;
            if (bag.isCurrent()) continue;
            clone.remove(bag.getName());
        }
        return clone;
    }

    private class MostPopularTemplateComparator
    implements Comparator<String> {
        private List<String> mostPopulareTemplateNames;
        private Map<String, WebSearchable> filteredWebSearchables;

        public MostPopularTemplateComparator(List<String> mostPopulareTemplateNames, Map<String, WebSearchable> filteredWebSearchables) {
            this.mostPopulareTemplateNames = mostPopulareTemplateNames;
            this.filteredWebSearchables = filteredWebSearchables;
        }

        @Override
        public int compare(String templateName1, String templateName2) {
            if (!this.mostPopulareTemplateNames.contains(templateName1) && !this.mostPopulareTemplateNames.contains(templateName2)) {
                WebSearchable ws1 = this.filteredWebSearchables.get(templateName1);
                WebSearchable ws2 = this.filteredWebSearchables.get(templateName2);
                String t1 = ws1.getTitle();
                String t2 = ws2.getTitle();
                if (t1 == null || t2 == null || t1.equals(t2)) {
                    return ws1.getName().compareTo(ws2.getName());
                }
                return ws1.getTitle().compareTo(ws2.getTitle());
            }
            if (!this.mostPopulareTemplateNames.contains(templateName1)) {
                return 1;
            }
            if (!this.mostPopulareTemplateNames.contains(templateName2)) {
                return -1;
            }
            return this.mostPopulareTemplateNames.indexOf(templateName1) < this.mostPopulareTemplateNames.indexOf(templateName2) ? -1 : 1;
        }
    }
}

