/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.web.struts;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.intermine.api.InterMineAPI;
import org.intermine.api.profile.Profile;
import org.intermine.api.profile.TagManager;
import org.intermine.api.query.codegen.WebserviceCodeGenInfo;
import org.intermine.api.query.codegen.WebserviceCodeGenerator;
import org.intermine.api.query.codegen.WebserviceJavaCodeGenerator;
import org.intermine.api.query.codegen.WebserviceJavaScriptCodeGenerator;
import org.intermine.api.query.codegen.WebservicePerlCodeGenerator;
import org.intermine.api.query.codegen.WebservicePythonCodeGenerator;
import org.intermine.api.query.codegen.WebserviceRubyCodeGenerator;
import org.intermine.api.template.TemplateManager;
import org.intermine.pathquery.PathQuery;
import org.intermine.template.TemplateQuery;
import org.intermine.web.logic.session.SessionMethods;
import org.intermine.web.struts.InterMineAction;
import org.intermine.web.util.URLGenerator;

public class WebserviceCodeGenAction
extends InterMineAction {
    protected static final Logger LOG = Logger.getLogger(WebserviceCodeGenAction.class);

    private WebserviceCodeGenerator getCodeGenerator(String method) {
        if ("perl".equals(method)) {
            return new WebservicePerlCodeGenerator();
        }
        if ("java".equals(method)) {
            return new WebserviceJavaCodeGenerator();
        }
        if ("python".equals(method)) {
            return new WebservicePythonCodeGenerator();
        }
        if ("javascript".equals(method)) {
            return new WebserviceJavaScriptCodeGenerator();
        }
        if ("ruby".equals(method)) {
            return new WebserviceRubyCodeGenerator();
        }
        throw new IllegalArgumentException("Unknown code generation language: " + method);
    }

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession();
        InterMineAPI im = SessionMethods.getInterMineAPI(session);
        Profile profile = SessionMethods.getProfile(session);
        Properties webProperties = SessionMethods.getWebProperties(request.getSession().getServletContext());
        String serviceBaseURL = new URLGenerator(request).getPermanentBaseURL();
        String projectTitle = webProperties.getProperty("project.title");
        String perlWSModuleVer = webProperties.getProperty("perl.wsModuleVer");
        try {
            String method = request.getParameter("method");
            String source = request.getParameter("source");
            WebserviceCodeGenInfo info = null;
            if ("templateQuery".equals(source)) {
                TemplateQuery template = this.getTemplateQuery(profile, request);
                info = this.getWebserviceCodeGenInfo((PathQuery)template, serviceBaseURL, projectTitle, perlWSModuleVer, WebserviceCodeGenAction.templateIsPublic(template, im, profile), profile);
            } else if ("pathQuery".equals(source)) {
                PathQuery pq = this.getPathQuery(session);
                info = this.getWebserviceCodeGenInfo(pq, serviceBaseURL, projectTitle, perlWSModuleVer, WebserviceCodeGenAction.pathQueryIsPublic(pq, im, profile), profile);
            }
            WebserviceCodeGenerator codeGen = this.getCodeGenerator(method);
            String sc = codeGen.generate(info);
            this.sendCode(sc, info.getFileName(), WebserviceCodeGenAction.getExtension(method), response);
        }
        catch (Exception e) {
            LOG.error((Object)e);
            e.printStackTrace();
            this.sendCode(e.toString(), "exception", "e", response);
            return mapping.findForward("begin");
        }
        return null;
    }

    private TemplateQuery getTemplateQuery(Profile profile, HttpServletRequest request) {
        TemplateQuery template;
        String name = request.getParameter("name");
        String scope = request.getParameter("scope");
        String originalTemplate = request.getParameter("originalTemplate");
        TemplateManager templateManager = SessionMethods.getInterMineAPI(request).getTemplateManager();
        if (name == null) {
            throw new IllegalArgumentException("Cannot find a template in context " + scope);
        }
        Object object = template = originalTemplate != null ? templateManager.getTemplate(profile, name, scope) : (TemplateQuery)SessionMethods.getQuery(request);
        if (template != null) {
            return template;
        }
        throw new IllegalArgumentException("Cannot find template " + name + " in context " + scope);
    }

    private PathQuery getPathQuery(HttpSession session) {
        PathQuery query = SessionMethods.getQuery(session);
        if (query != null) {
            return new PathQuery(query);
        }
        throw new IllegalArgumentException("Cannot find a query");
    }

    protected static boolean templateIsPublic(TemplateQuery t, InterMineAPI im, Profile p) {
        Map templates = p.getSavedTemplates();
        return !templates.keySet().contains(t.getName()) && WebserviceCodeGenAction.pathQueryIsPublic((PathQuery)t, im, p);
    }

    protected static boolean pathQueryIsPublic(PathQuery pq, InterMineAPI im, Profile p) {
        Set listNames = pq.getBagNames();
        TagManager tm = im.getTagManager();
        for (String name : listNames) {
            Set tags = tm.getObjectTagNames(name, "bag", p.getUsername());
            if (tags.contains("im:public")) continue;
            return false;
        }
        return true;
    }

    private WebserviceCodeGenInfo getWebserviceCodeGenInfo(PathQuery query, String serviceRootURL, String projectTitle, String perlWSModuleVer, boolean isPublic, Profile user) {
        WebserviceCodeGenInfo wsCodeGenInfo = new WebserviceCodeGenInfo(query, serviceRootURL, projectTitle, perlWSModuleVer, isPublic, user);
        return wsCodeGenInfo;
    }

    private void sendCode(String sourceCodeString, String extension, String filename, HttpServletResponse response) {
        response.setContentType("text/plain; charset=utf-8");
        try {
            PrintStream out = new PrintStream((OutputStream)response.getOutputStream());
            out.print(sourceCodeString);
            out.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static String getExtension(String method) {
        if ("perl".equalsIgnoreCase(method)) {
            return "pl";
        }
        if ("python".equalsIgnoreCase(method)) {
            return "py";
        }
        if ("javascript".equalsIgnoreCase(method)) {
            return "html";
        }
        return method;
    }
}

