/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.web.struts.oauth2;

import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.oltu.oauth2.client.HttpClient;
import org.apache.oltu.oauth2.client.OAuthClient;
import org.apache.oltu.oauth2.client.URLConnectionClient;
import org.apache.oltu.oauth2.client.request.OAuthBearerClientRequest;
import org.apache.oltu.oauth2.client.request.OAuthClientRequest;
import org.apache.oltu.oauth2.client.response.GitHubTokenResponse;
import org.apache.oltu.oauth2.client.response.OAuthAccessTokenResponse;
import org.apache.oltu.oauth2.client.response.OAuthAuthzResponse;
import org.apache.oltu.oauth2.client.response.OAuthResourceResponse;
import org.apache.oltu.oauth2.common.OAuthProviderType;
import org.apache.oltu.oauth2.common.exception.OAuthProblemException;
import org.apache.oltu.oauth2.common.exception.OAuthSystemException;
import org.apache.oltu.oauth2.common.message.types.GrantType;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.intermine.api.InterMineAPI;
import org.intermine.api.profile.DuplicateMappingException;
import org.intermine.api.profile.Profile;
import org.intermine.web.context.InterMineContext;
import org.intermine.web.logic.profile.LoginHandler;
import org.intermine.web.logic.profile.ProfileMergeIssues;
import org.intermine.web.logic.session.SessionMethods;
import org.intermine.web.struts.oauth2.CustomOAuthProvider;
import org.intermine.web.struts.oauth2.DefaultOAuthProvider;
import org.intermine.web.struts.oauth2.DelegatedIdentity;
import org.intermine.web.struts.oauth2.ForseenProblem;
import org.intermine.web.struts.oauth2.MigrationMapping;
import org.intermine.web.struts.oauth2.OAuthProvider;
import org.json.JSONException;
import org.json.JSONObject;

public class Callback
extends LoginHandler {
    private static final Logger LOG = Logger.getLogger(Callback.class);

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        Properties webProperties = InterMineContext.getWebProperties();
        String providerName = request.getParameter("provider");
        String redirectUri = this.getRedirectUri(webProperties, providerName);
        try {
            OAuthProvider provider = this.getOAuthProvider(mapping, request, webProperties, providerName);
            OAuthAuthzResponse oar = this.getAuthResponse(mapping, request);
            this.checkOauthState(mapping, request, oar);
            ActionMessages messages = null;
            messages = "GOOGLE".equals(providerName) ? this.googleProviderFlow(request, providerName, redirectUri, provider, oar) : this.standardProviderFlow(request, providerName, redirectUri, provider, oar);
            this.saveMessages(request, messages);
            return mapping.findForward("mymine");
        }
        catch (ForseenProblem e) {
            ActionErrors errors = new ActionErrors();
            errors.add("org.apache.struts.action.GLOBAL_MESSAGE", e.getActionMessage());
            this.saveErrors(request, (ActionMessages)errors);
            return mapping.findForward("login");
        }
        catch (Exception e) {
            LOG.error((Object)"Error granting access", (Throwable)e);
            ActionErrors errors = new ActionErrors();
            errors.add("org.apache.struts.action.GLOBAL_MESSAGE", new ActionMessage("oauth2.error.granting", (Object)e.getLocalizedMessage()));
            this.saveErrors(request, (ActionMessages)errors);
            return mapping.findForward("login");
        }
    }

    private ActionMessages googleProviderFlow(HttpServletRequest request, String providerName, String redirectUri, OAuthProvider provider, OAuthAuthzResponse oar) throws ForseenProblem, OAuthSystemException, OAuthProblemException, JSONException {
        JSONObject respData;
        OAuthAccessTokenResponse resp = this.getTokenResponse(redirectUri, oar, provider);
        LOG.debug((Object)("GOOGLE RESPONSE: " + resp.getBody()));
        MigrationMapping migrationMapping = null;
        Base64 decoder = new Base64();
        String accessToken = resp.getAccessToken();
        try {
            respData = new JSONObject(resp.getBody());
        }
        catch (JSONException e) {
            throw new ForseenProblem("oauth2.error.bad-json");
        }
        String jwt = respData.optString("id_token");
        if (jwt != null) {
            String[] pieces = jwt.split("\\.");
            if (pieces.length == 3) {
                JSONObject claims = new JSONObject(new String(decoder.decode(pieces[1])));
                String openidID = claims.optString("openid_id");
                String sub = claims.optString("sub");
                migrationMapping = new MigrationMapping(openidID, sub);
            } else {
                LOG.error((Object)"id_token is not a valid JWT - has Google changed their API?");
            }
        } else {
            LOG.debug((Object)"No id_token (and thus migration info) provided by Google");
        }
        DelegatedIdentity identity = this.getDelegatedIdentity(providerName, accessToken);
        return this.loginUser(request, identity, migrationMapping);
    }

    private ActionMessages standardProviderFlow(HttpServletRequest request, String providerName, String redirectUri, OAuthProvider provider, OAuthAuthzResponse oar) throws OAuthSystemException, OAuthProblemException, JSONException {
        String accessToken = this.getAccessToken(redirectUri, oar, provider);
        DelegatedIdentity identity = this.getDelegatedIdentity(providerName, accessToken);
        ActionMessages messages = this.loginUser(request, identity);
        return messages;
    }

    private String getRedirectUri(Properties webProperties, String providerName) {
        ArrayList<String> redirectParts = new ArrayList<String>();
        redirectParts.add(webProperties.getProperty("webapp.baseurl"));
        redirectParts.add(webProperties.getProperty("webapp.path"));
        redirectParts.add("oauth2callback.do?provider=" + providerName);
        return StringUtils.join(redirectParts, (String)"/");
    }

    private OAuthAuthzResponse getAuthResponse(ActionMapping mapping, HttpServletRequest request) throws ForseenProblem {
        OAuthAuthzResponse oar;
        try {
            oar = OAuthAuthzResponse.oauthCodeAuthzResponse((HttpServletRequest)request);
        }
        catch (OAuthProblemException e) {
            throw new ForseenProblem("oauth2.error.getting-code", e.getMessage());
        }
        return oar;
    }

    private void checkOauthState(ActionMapping mapping, HttpServletRequest request, OAuthAuthzResponse oar) throws ForseenProblem {
        String state = (String)request.getSession().getAttribute("oauth2.state");
        if (state == null || !state.equals(oar.getState())) {
            throw new ForseenProblem("oauth2.error.illegal-request");
        }
    }

    private OAuthProvider getOAuthProvider(ActionMapping mapping, HttpServletRequest request, Properties webProperties, String providerName) throws ForseenProblem {
        OAuthProvider provider;
        try {
            provider = this.getProvider(webProperties, providerName);
        }
        catch (IllegalArgumentException e) {
            throw new ForseenProblem("oauth2.error.unknown-provider", providerName);
        }
        return provider;
    }

    private OAuthAccessTokenResponse getTokenResponse(String redirect, OAuthAuthzResponse oar, OAuthProvider provider) throws OAuthSystemException, OAuthProblemException {
        OAuthClientRequest clientReq;
        OAuthClient oauthClient = new OAuthClient((HttpClient)new URLConnectionClient());
        OAuthClientRequest.TokenRequestBuilder requestBuilder = OAuthClientRequest.tokenLocation((String)provider.getTokenUrl()).setGrantType(GrantType.AUTHORIZATION_CODE).setClientId(provider.getClientId()).setClientSecret(provider.getClientSecret()).setRedirectURI(redirect).setCode(oar.getCode());
        switch (provider.getMessageFormat()) {
            case BODY: {
                clientReq = requestBuilder.buildBodyMessage();
                break;
            }
            case QUERY: {
                clientReq = requestBuilder.buildQueryMessage();
                break;
            }
            default: {
                throw new RuntimeException("Unknown message format");
            }
        }
        LOG.info((Object)("Requesting access token: URI = " + clientReq.getLocationUri() + " BODY = " + clientReq.getBody()));
        switch (provider.getResponseType()) {
            case FORM: {
                return oauthClient.accessToken(clientReq, GitHubTokenResponse.class);
            }
            case JSON: {
                return oauthClient.accessToken(clientReq);
            }
        }
        throw new RuntimeException("Unknown response type");
    }

    private String getAccessToken(String redirect, OAuthAuthzResponse oar, OAuthProvider provider) throws OAuthSystemException, OAuthProblemException {
        OAuthAccessTokenResponse oauthResponse = this.getTokenResponse(redirect, oar, provider);
        String accessToken = oauthResponse.getAccessToken();
        return accessToken;
    }

    private OAuthProvider getProvider(Properties properties, String providerName) {
        if (properties.containsKey("oauth2." + providerName + ".url.token")) {
            return new CustomOAuthProvider(properties, providerName);
        }
        return new DefaultOAuthProvider(properties, OAuthProviderType.valueOf((String)providerName));
    }

    private ActionMessages loginUser(HttpServletRequest request, DelegatedIdentity identity) {
        return this.loginUser(request, identity, null);
    }

    private ActionMessages loginUser(HttpServletRequest request, DelegatedIdentity identity, MigrationMapping mapping) {
        LOG.debug((Object)("Logging in " + identity + " with migration mapping " + mapping));
        Profile currentProfile = SessionMethods.getProfile(request.getSession());
        InterMineAPI api = SessionMethods.getInterMineAPI(request.getSession());
        Profile profile = api.getProfileManager().grantPermission(identity.getProvider(), identity.getId(), (Map)api.getClassKeys()).getProfile();
        Map preferences = profile.getPreferences();
        if (!preferences.containsKey("email")) {
            preferences.put("email", identity.getEmail());
        }
        preferences.put("email", identity.getEmail());
        String identityName = identity.getName();
        if (!"".equals(identityName)) {
            String aka = "";
            if (preferences.containsKey("aka")) {
                aka = (String)preferences.get("aka");
            }
            if ("".equals(aka)) {
                preferences.put("aka", identityName);
            }
            String alias = "";
            if (preferences.containsKey("alias")) {
                alias = (String)preferences.get("alias");
            }
            if ("".equals(alias)) {
                int c = 0;
                alias = identityName;
                do {
                    try {
                        preferences.put("alias", alias);
                    }
                    catch (DuplicateMappingException e) {
                        alias = identityName + " " + ++c;
                    }
                } while (!preferences.containsKey("alias"));
            }
        }
        ActionMessages messages = new ActionMessages();
        Callback.setUpProfile(request.getSession(), profile);
        messages.add("org.apache.struts.action.GLOBAL_MESSAGE", new ActionMessage("login.oauth2.successful", (Object)identity.getProvider(), (Object)profile.getName()));
        ProfileMergeIssues issues = new ProfileMergeIssues();
        if (currentProfile != null && StringUtils.isEmpty((String)currentProfile.getUsername())) {
            issues = Callback.mergeProfiles(currentProfile, profile);
        }
        api.getTrackerDelegate().trackLogin(profile.getUsername());
        for (Map.Entry<String, String> pair : issues.getRenamedBags().entrySet()) {
            messages.add("org.apache.struts.action.GLOBAL_MESSAGE", new ActionMessage("login.renamed.bag", (Object)pair.getKey(), (Object)pair.getValue()));
        }
        for (Map.Entry<String, String> renamed : issues.getRenamedTemplates().entrySet()) {
            messages.add("org.apache.struts.action.GLOBAL_MESSAGE", new ActionMessage("login.failedtemplate", (Object)renamed.getKey(), (Object)renamed.getValue()));
        }
        return messages;
    }

    private DelegatedIdentity getDelegatedIdentity(String providerName, String accessToken) throws OAuthSystemException, OAuthProblemException, JSONException {
        if (this.providerIsSane(providerName)) {
            return this.getSaneProviderUserInfo(providerName, accessToken);
        }
        throw new RuntimeException("Missing config: oauth2." + providerName + ".identity-resource");
    }

    private boolean providerIsSane(String providerName) {
        Properties webProperties = InterMineContext.getWebProperties();
        return webProperties.containsKey("oauth2." + providerName + ".identity-resource");
    }

    private DelegatedIdentity getSaneProviderUserInfo(String provider, String accessToken) throws OAuthSystemException, OAuthProblemException, JSONException {
        OAuthClientRequest bearerClientRequest;
        Properties props = InterMineContext.getWebProperties();
        String prefix = "oauth2." + provider;
        String identityEndpoint = props.getProperty(prefix + ".identity-resource");
        String envelopeKey = props.getProperty(prefix + ".identity-envelope");
        String idKey = props.getProperty(prefix + ".id-key", "id");
        String nameKey = props.getProperty(prefix + ".name-key", "name");
        String emailKey = props.getProperty(prefix + ".email-key", "email");
        String authMechanism = props.getProperty(prefix + ".resource-auth-mechanism", "queryparam");
        OAuthBearerClientRequest requestBuilder = new OAuthBearerClientRequest(identityEndpoint).setAccessToken(accessToken);
        if ("queryparam".equals(authMechanism)) {
            bearerClientRequest = requestBuilder.buildQueryMessage();
        } else if ("header".equals(authMechanism)) {
            bearerClientRequest = requestBuilder.buildHeaderMessage();
        } else if ("body".equals(authMechanism)) {
            bearerClientRequest = requestBuilder.buildBodyMessage();
        } else {
            throw new OAuthSystemException("Unknown authorisation mechanism: " + authMechanism);
        }
        LOG.debug((Object)("Requesting identity information: URI = " + bearerClientRequest.getLocationUri() + " HEADERS = " + bearerClientRequest.getHeaders() + " BODY = " + bearerClientRequest.getBody()));
        bearerClientRequest.setHeader("Accept", "application/json");
        OAuthClient oauthClient = new OAuthClient((HttpClient)new URLConnectionClient());
        OAuthResourceResponse resp = (OAuthResourceResponse)oauthClient.resource(bearerClientRequest, "GET", OAuthResourceResponse.class);
        return this.parseIdentity(provider, envelopeKey, idKey, nameKey, emailKey, resp.getBody());
    }

    private DelegatedIdentity parseIdentity(String provider, String envelopeKey, String idKey, String nameKey, String emailKey, String body) throws JSONException {
        String email;
        JSONObject result = new JSONObject(body);
        if (StringUtils.isNotBlank((String)envelopeKey)) {
            result = result.getJSONObject(envelopeKey);
        }
        String id = result.get(idKey).toString();
        String[] nameKeyParts = nameKey.split(",");
        Object[] nameParts = new String[nameKeyParts.length];
        for (int i = 0; i < nameKeyParts.length; ++i) {
            nameParts[i] = result.getString(nameKeyParts[i]);
        }
        String name = StringUtils.join((Object[])nameParts, (String)" ");
        JSONObject emails = result.optJSONObject("emails");
        if (emails == null) {
            email = result.optString(emailKey);
        } else {
            email = emails.optString("preferred");
            if (email == null) {
                email = emails.optString("account");
            }
        }
        return new DelegatedIdentity(provider, id, email, name);
    }
}

