/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.web.struts.oauth2;

import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.intermine.web.struts.oauth2.MessageFormat;
import org.intermine.web.struts.oauth2.OAuthProvider;
import org.intermine.web.struts.oauth2.ResponseType;

public final class CustomOAuthProvider
implements OAuthProvider {
    private final String name;
    private final String tokenUrl;
    private final String clientId;
    private final String clientSecret;
    private final MessageFormat messageFormat;
    private final ResponseType responseType;

    public CustomOAuthProvider(Properties properties, String providerName) {
        String prefix = "oauth2." + providerName;
        this.name = providerName;
        this.tokenUrl = properties.getProperty(prefix + ".url.token");
        this.clientId = properties.getProperty(prefix + ".client-id");
        this.clientSecret = properties.getProperty(prefix + ".client-secret");
        this.messageFormat = MessageFormat.valueOf(properties.getProperty(prefix + ".messageformat"));
        this.responseType = ResponseType.valueOf(properties.getProperty(prefix + ".responsetype"));
        if (this.tokenUrl == null) {
            throw new IllegalArgumentException("Bad config: tokenUrl must not be null.");
        }
        if (StringUtils.isBlank((String)this.clientId) || StringUtils.isBlank((String)this.clientSecret)) {
            throw new IllegalArgumentException("Bad config: no client config for " + providerName);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getClientId() {
        return this.clientId;
    }

    @Override
    public String getClientSecret() {
        return this.clientSecret;
    }

    @Override
    public String getTokenUrl() {
        return this.tokenUrl;
    }

    @Override
    public MessageFormat getMessageFormat() {
        return this.messageFormat;
    }

    @Override
    public ResponseType getResponseType() {
        return this.responseType;
    }
}

