/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.web.tags.table;

import java.io.IOException;
import java.util.List;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.SimpleTagSupport;

public class TableTag
extends SimpleTagSupport {
    private List<String> columnNames;
    private List<List<String>> rows;
    private boolean treatColNames = false;
    private String noResultsMessage;

    public boolean isTreatColNames() {
        return this.treatColNames;
    }

    public void setTreatColNames(boolean treatColNames) {
        this.treatColNames = treatColNames;
    }

    public void doTag() throws IOException {
        JspWriter writer = this.getJspContext().getOut();
        StringBuilder sb = new StringBuilder();
        sb.append("<table border=\"1px\" style=\"border-collapse:collapse;\" class=\"results\" cellspacing=\"0\">");
        sb.append(this.getHeaderHtml());
        sb.append(this.getBodyHtml());
        sb.append("</table>");
        writer.print(sb.toString());
    }

    private String getHeaderHtml() {
        if (this.columnNames == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("<tr>\n");
        for (String name : this.columnNames) {
            sb.append("<th align=\"center\">");
            if (this.isTreatColNames()) {
                sb.append(this.treatColumnName(name));
            } else {
                sb.append(name);
            }
            sb.append("</th>\n");
        }
        sb.append("</tr>\n");
        return sb.toString();
    }

    private String treatColumnName(String str) {
        String repl = "XXXXXXXXXXXXXXXXXXXXXXXX";
        String ret = str.replaceAll("[.][ ]", repl);
        ret = ret.replaceAll("[.]", "&nbsp;> ");
        ret = ret.replaceAll(repl, ". ");
        return ret;
    }

    public List<List<String>> getRows() {
        return this.rows;
    }

    public void setRows(List<List<String>> rows) {
        this.rows = rows;
    }

    public List<String> getColumnNames() {
        return this.columnNames;
    }

    public void setColumnNames(List<String> columnNames) {
        this.columnNames = columnNames;
    }

    private String getBodyHtml() {
        if (this.rows == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        if (this.rows.size() == 0) {
            String ret = "<tr><td colspan=\"" + this.getColumnsCount() + "\">" + this.getNoResultsMessage() + "</td>";
            ret = ret + "</tr>";
            return ret;
        }
        for (int i = 0; i < this.rows.size(); ++i) {
            int cellIndex;
            List<String> row = this.rows.get(i);
            sb.append("<tr>\n");
            for (cellIndex = 0; cellIndex < row.size(); ++cellIndex) {
                String cell = row.get(cellIndex);
                sb.append("<td>");
                if (cell == null || cell.length() == 0) {
                    sb.append("&nbsp;");
                } else {
                    sb.append(cell);
                }
                sb.append("</td>\n");
            }
            sb.append(this.getEmptyCellsHtml(this.getColumnsCount() - cellIndex - 1));
            sb.append("</tr>\n");
        }
        return sb.toString();
    }

    public String getNoResultsMessage() {
        if (this.noResultsMessage != null) {
            return this.noResultsMessage;
        }
        return "There are no results. If you browsed through results go to the previous page.";
    }

    public void setNoResultsMessage(String noResultsMessage) {
        this.noResultsMessage = noResultsMessage;
    }

    private int getColumnsCount() {
        if (this.columnNames != null) {
            return this.columnNames.size();
        }
        return 0;
    }

    private String getEmptyCellsHtml(int count) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < count; ++i) {
            sb.append("<td>&nbsp;</td>\n");
        }
        return sb.toString();
    }
}

