/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.web.uri;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Set;
import org.intermine.metadata.Model;
import org.intermine.web.uri.InvalidPermanentURLException;

public class InterMineLUI {
    private String className;
    private static final String LOCAL_ID_SEPARATOR = ":";
    private String identifier;

    public InterMineLUI(String className, String identifier) {
        this.className = className;
        this.identifier = identifier;
    }

    public InterMineLUI(String permanentURI) throws InvalidPermanentURLException {
        int localIdStartPosition = permanentURI.lastIndexOf("/") + 1;
        int localIdSeparatorPos = permanentURI.indexOf(LOCAL_ID_SEPARATOR, localIdStartPosition);
        if (localIdSeparatorPos == -1) {
            throw new InvalidPermanentURLException();
        }
        try {
            String classNameFromURI = permanentURI.substring(localIdStartPosition, localIdSeparatorPos);
            this.className = InterMineLUI.getSimpleClassName(classNameFromURI);
            if (this.className == null) {
                throw new InvalidPermanentURLException();
            }
            String encodedIdentifier = permanentURI.substring(localIdSeparatorPos + 1);
            try {
                this.identifier = URLDecoder.decode(encodedIdentifier, "UTF-8");
            }
            catch (UnsupportedEncodingException ex) {
                this.identifier = encodedIdentifier;
            }
        }
        catch (IndexOutOfBoundsException ex) {
            throw new InvalidPermanentURLException();
        }
    }

    protected static String getSimpleClassName(String className) {
        Model model = Model.getInstanceByName((String)"genomic");
        Set fullyQualifiedClassNames = model.getClassNames();
        for (String fullyQualifiedClassName : fullyQualifiedClassNames) {
            String simpleClassName = fullyQualifiedClassName.substring(fullyQualifiedClassName.lastIndexOf(".") + 1);
            if (!simpleClassName.toLowerCase().equals(className.toLowerCase())) continue;
            return simpleClassName;
        }
        return null;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public String toString() {
        try {
            String encodedIdentifier = URLEncoder.encode(this.identifier, "UTF-8");
            encodedIdentifier = encodedIdentifier.replaceAll("%3A", LOCAL_ID_SEPARATOR).replaceAll("\\+", "%20");
            return this.className.toLowerCase() + LOCAL_ID_SEPARATOR + encodedIdentifier;
        }
        catch (UnsupportedEncodingException ex) {
            return this.className.toLowerCase() + LOCAL_ID_SEPARATOR + this.identifier;
        }
    }
}

