/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.web.uri;

import org.apache.log4j.Logger;
import org.intermine.api.InterMineAPI;
import org.intermine.api.identifiers.IdentifiersMapper;
import org.intermine.api.query.PathQueryExecutor;
import org.intermine.api.results.ExportResultsIterator;
import org.intermine.api.results.ResultElement;
import org.intermine.metadata.Model;
import org.intermine.model.FastPathObject;
import org.intermine.model.InterMineObject;
import org.intermine.objectstore.ObjectStoreException;
import org.intermine.pathquery.Constraints;
import org.intermine.pathquery.PathConstraint;
import org.intermine.pathquery.PathQuery;
import org.intermine.util.DynamicUtil;
import org.intermine.web.context.InterMineContext;
import org.intermine.web.uri.InterMineLUI;

public class InterMineLUIConverter {
    private static final Integer INTERMINE_ID_NOT_FOUND = -1;
    private static final Logger LOGGER = Logger.getLogger(InterMineLUIConverter.class);

    public Integer getInterMineID(InterMineLUI interMineLUI) throws ObjectStoreException {
        if (interMineLUI == null) {
            throw new RuntimeException("InterMineLUI is null");
        }
        PathQuery pathQuery = new PathQuery(this.getModel());
        String className = interMineLUI.getClassName();
        String viewPath = className + ".id";
        pathQuery.addView(viewPath);
        String identifier = IdentifiersMapper.getMapper().getIdentifier(className);
        if (identifier == null) {
            LOGGER.info((Object)("No " + className + "_URI defined in the class_key.properties file"));
            return INTERMINE_ID_NOT_FOUND;
        }
        String constraintPath = className + "." + identifier;
        pathQuery.addConstraint((PathConstraint)Constraints.eq((String)constraintPath, (String)interMineLUI.getIdentifier()));
        if (!pathQuery.isValid()) {
            LOGGER.info((Object)("The PathQuery :" + pathQuery.toString() + " is not valid. No " + className + "_URI defined in the class_key.properties file"));
            return INTERMINE_ID_NOT_FOUND;
        }
        LOGGER.info((Object)("InterMineLUIConverter: pathQuery to retrieve internal id: " + pathQuery.toString()));
        ExportResultsIterator iterator = this.getPathQueryExecutor().execute(pathQuery);
        if (iterator.hasNext()) {
            ResultElement row = (ResultElement)iterator.next().get(0);
            return row.getId();
        }
        LOGGER.info((Object)("InterMineLUIConverter: there are no " + className + " with " + constraintPath + "=" + interMineLUI.getIdentifier()));
        return INTERMINE_ID_NOT_FOUND;
    }

    public InterMineObject getInterMineObject(InterMineLUI interMineLUI) throws ObjectStoreException {
        if (interMineLUI == null) {
            throw new RuntimeException("InterMineLUI is null");
        }
        PathQuery pathQuery = new PathQuery(this.getModel());
        String className = interMineLUI.getClassName();
        String viewPath = className + ".id";
        pathQuery.addView(viewPath);
        String identifier = IdentifiersMapper.getMapper().getIdentifier(className);
        if (identifier == null) {
            LOGGER.info((Object)("No " + className + "_URI defined in the class_key.properties file"));
            return null;
        }
        String constraintPath = className + "." + identifier;
        pathQuery.addConstraint((PathConstraint)Constraints.eq((String)constraintPath, (String)interMineLUI.getIdentifier()));
        if (!pathQuery.isValid()) {
            LOGGER.info((Object)("The PathQuery :" + pathQuery.toString() + " is not valid. No " + className + "_URI defined in the class_key.properties file"));
            return null;
        }
        LOGGER.info((Object)("InterMineLUIConverter: pathQuery to retrieve internal id: " + pathQuery.toString()));
        ExportResultsIterator iterator = this.getPathQueryExecutor().execute(pathQuery);
        if (iterator.hasNext()) {
            ResultElement row = (ResultElement)iterator.next().get(0);
            InterMineAPI im = this.getInterMineAPI();
            return im.getObjectStore().getObjectById(row.getId());
        }
        LOGGER.info((Object)("InterMineLUIConverter: there are no " + className + " with " + constraintPath + "=" + interMineLUI.getIdentifier()));
        return null;
    }

    public InterMineLUI getInterMineLUI(Integer interMineID) {
        if (interMineID == null) {
            LOGGER.error((Object)"intermineID is null");
            return null;
        }
        String type = null;
        String identifier = null;
        try {
            InterMineAPI im = this.getInterMineAPI();
            InterMineObject entity = im.getObjectStore().getObjectById(interMineID);
            if (entity == null) {
                return null;
            }
            type = DynamicUtil.getSimpleClass((FastPathObject)entity).getSimpleName();
            String identifierField = IdentifiersMapper.getMapper().getIdentifier(type);
            if (identifierField == null) {
                LOGGER.info((Object)("The entity " + interMineID + " has no key configured, the share link will not be displayed in the report page. Configure a different key in the class_keys.properties file"));
                return null;
            }
            identifier = (String)entity.getFieldValue(identifierField);
            if (identifier == null) {
                LOGGER.info((Object)("The entity " + interMineID + " has " + identifierField + " null, the share link will not be displayed in the report page. Configure a different key in the class_keys.properties file"));
                return null;
            }
        }
        catch (ObjectStoreException ose) {
            LOGGER.error((Object)("Failed to find object with id: " + interMineID), (Throwable)ose);
            return null;
        }
        catch (IllegalAccessException iae) {
            LOGGER.error((Object)("Failed to get identifier fot the entity with id: " + interMineID), (Throwable)iae);
            return null;
        }
        return new InterMineLUI(type, identifier);
    }

    protected Model getModel() {
        return Model.getInstanceByName((String)"genomic");
    }

    protected InterMineAPI getInterMineAPI() {
        return InterMineContext.getInterMineAPI();
    }

    private PathQueryExecutor getPathQueryExecutor() {
        InterMineAPI im = this.getInterMineAPI();
        return new PathQueryExecutor(im.getObjectStore(), null, null, im.getBagManager());
    }
}

