/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.webservice.server;

import java.util.ArrayList;
import java.util.List;

public abstract class CodeTranslator {
    private static List<Operation> operations = new ArrayList<Operation>();

    private CodeTranslator() {
    }

    public static String getCode(String translated) {
        Operation op = CodeTranslator.getOperation(translated);
        if (op != null) {
            return op.getCode();
        }
        return translated;
    }

    public static String getAbbreviation(String translated) {
        Operation op = CodeTranslator.getOperation(translated);
        if (op != null) {
            return op.getAbbreviation();
        }
        return translated;
    }

    public static String getFullName(String translated) {
        Operation op = CodeTranslator.getOperation(translated);
        if (op != null) {
            return op.getFullName();
        }
        return translated;
    }

    private static Operation getOperation(String translated) {
        for (Operation op : operations) {
            if (!op.isEquivalent(translated)) continue;
            return op;
        }
        return null;
    }

    static {
        operations.add(new Operation("=", "eq", "equals"));
        operations.add(new Operation("!=", "ne", "notequals"));
        operations.add(new Operation("<", "lt", "lessthan"));
        operations.add(new Operation("<=", "le", "lessthanequals"));
        operations.add(new Operation(">", "gt", "greaterthan"));
        operations.add(new Operation(">=", "ge", "greaterthanequals"));
    }

    private static class Operation {
        private final String code;
        private final String abbrev;
        private final String fullName;

        public Operation(String code, String abbrev, String fullName) {
            this.code = code;
            this.abbrev = abbrev;
            this.fullName = fullName;
        }

        public boolean isEquivalent(String other) {
            if (this.code != null && this.code.equalsIgnoreCase(other)) {
                return true;
            }
            if (this.abbrev != null && this.abbrev.equalsIgnoreCase(other)) {
                return true;
            }
            return this.fullName != null && this.fullName.equalsIgnoreCase(other);
        }

        public String getCode() {
            return this.code;
        }

        public String getAbbreviation() {
            return this.abbrev;
        }

        public String getFullName() {
            return this.fullName;
        }
    }
}

