/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.webservice.server;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.solr.client.solrj.response.FacetField;
import org.intermine.api.InterMineAPI;
import org.intermine.api.searchengine.KeywordSearchFacet;
import org.intermine.api.searchengine.KeywordSearchFacetData;
import org.intermine.api.searchengine.KeywordSearchPropertiesManager;
import org.intermine.api.searchengine.solr.SolrKeywordSearchHandler;
import org.intermine.objectstore.ObjectStore;
import org.intermine.webservice.server.core.JSONService;
import org.json.JSONArray;
import org.json.JSONObject;

public class FacetService
extends JSONService {
    private static final Logger LOG = Logger.getLogger(FacetService.class);

    public FacetService(InterMineAPI im) {
        super(im);
    }

    @Override
    protected String getResultsKey() {
        return "facets";
    }

    @Override
    protected void execute() throws Exception {
        KeywordSearchPropertiesManager keywordSearchPropertiesManager = KeywordSearchPropertiesManager.getInstance((ObjectStore)this.im.getObjectStore());
        Vector facets = keywordSearchPropertiesManager.getFacets();
        SolrKeywordSearchHandler searchHandler = new SolrKeywordSearchHandler();
        String searchTerm = this.request.getParameter("q");
        Map<String, String> facetValues = this.getFacetValues(this.request, facets);
        Collection keywordSearchFacets = searchHandler.doFacetSearch(this.im, searchTerm, facetValues);
        this.output.setHeaderAttributes(this.getHeaderAttributes());
        HashMap ckData = new HashMap();
        JSONArray rootArray = new JSONArray();
        for (KeywordSearchFacet keywordSearchFacet : keywordSearchFacets) {
            HashMap<String, Long> temp = new HashMap<String, Long>();
            JSONArray innerArray = new JSONArray();
            for (FacetField.Count count : keywordSearchFacet.getItems()) {
                temp.put(count.getName(), count.getCount());
                JSONObject innerObject = new JSONObject();
                innerObject.put("name", (Object)count.getName());
                innerObject.put("value", count.getCount());
                innerArray.put((Object)innerObject);
            }
            ckData.put(keywordSearchFacet.getName(), temp);
            JSONObject outerObject = new JSONObject();
            outerObject.put(keywordSearchFacet.getName(), (Object)innerArray);
            rootArray.put((Object)outerObject);
        }
        JSONObject jo = new JSONObject();
        jo.put("results", (Object)rootArray);
        this.output.addResultItem(Collections.singletonList(jo.toString()));
    }

    private Map<String, String> getFacetValues(HttpServletRequest request, Vector<KeywordSearchFacetData> facets) {
        HashMap<String, String> facetValues = new HashMap<String, String>();
        if (StringUtils.isBlank((String)request.getParameter("searchSubmit")) || !StringUtils.isBlank((String)request.getParameter("searchSubmitRestricted"))) {
            for (Map.Entry entry : request.getParameterMap().entrySet()) {
                if (!((String)entry.getKey()).startsWith("facet_") || ((String[])entry.getValue()).length <= 0 || StringUtils.isBlank((String)((String[])entry.getValue())[0])) continue;
                String facetField = ((String)entry.getKey()).substring("facet_".length());
                boolean found = false;
                for (KeywordSearchFacetData keywordSearchFacetData : facets) {
                    if (!facetField.equals(keywordSearchFacetData.getField())) continue;
                    found = true;
                    break;
                }
                if (!found) continue;
                facetValues.put(facetField, ((String[])entry.getValue())[0]);
            }
            for (Map.Entry<Object, Object> entry : facetValues.entrySet()) {
                LOG.debug((Object)("SEARCH FACET: " + (String)entry.getKey() + " = " + (String)entry.getValue()));
            }
        }
        return facetValues;
    }
}

