/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.webservice.server;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.intermine.web.logic.export.ResponseUtil;
import org.intermine.webservice.server.ServiceListingHandler;
import org.intermine.webservice.server.VersionServlet;
import org.intermine.webservice.server.exceptions.ServiceException;
import org.json.JSONException;
import org.json.JSONObject;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ServicesListingsServlet
extends HttpServlet {
    private static final Logger LOGGER = Logger.getLogger(VersionServlet.class);
    private static final String FILENAME = "services.json";
    private static final String WEB_XML = "web.xml";
    private static final long serialVersionUID = 1L;
    private static JSONObject services = null;

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.runService(request, response);
    }

    public void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.runService(req, resp);
    }

    private void parseWebXML() {
        String path = this.getServletContext().getRealPath("/WEB-INF/web.xml");
        File webxml = new File(path);
        SAXParser parser = this.getParser();
        ServiceListingHandler handler = this.getHandler();
        try {
            parser.parse(webxml, (DefaultHandler)handler);
            services = handler.getServices();
        }
        catch (IOException e) {
            throw new ServiceException(e);
        }
        catch (SAXException e) {
            throw new ServiceException(e);
        }
    }

    private SAXParser getParser() {
        SAXParserFactory fac = SAXParserFactory.newInstance();
        SAXParser parser = null;
        try {
            parser = fac.newSAXParser();
        }
        catch (SAXException e) {
            LOGGER.error((Object)e);
        }
        catch (ParserConfigurationException e) {
            LOGGER.error((Object)e);
        }
        if (parser == null) {
            throw new ServiceException("Could not create a SAX parser");
        }
        return parser;
    }

    private ServiceListingHandler getHandler() {
        return new ServiceListingHandler();
    }

    private void setHeaders(String format, HttpServletRequest request, HttpServletResponse response) {
        if ("text".equalsIgnoreCase(format)) {
            ResponseUtil.setPlainTextHeader(response, FILENAME);
        } else if (!StringUtils.isEmpty((String)request.getParameter("callback"))) {
            ResponseUtil.setJSONPHeader(response, FILENAME);
        } else {
            ResponseUtil.setJSONHeader(response, FILENAME);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runService(HttpServletRequest request, HttpServletResponse response) {
        String format = request.getParameter("format");
        String callback = request.getParameter("callback");
        this.setHeaders(format, request, response);
        if (services == null) {
            try {
                this.parseWebXML();
            }
            catch (ServiceException e) {
                response.setStatus(e.getHttpErrorCode());
                LOGGER.error((Object)e);
                return;
            }
            catch (Throwable t) {
                response.setStatus(500);
                LOGGER.error((Object)t);
                t.printStackTrace();
                return;
            }
        }
        try (PrintWriter pw = null;){
            response.setStatus(200);
            pw = response.getWriter();
            if ("text".equalsIgnoreCase(format)) {
                try {
                    for (String name : JSONObject.getNames((JSONObject)services)) {
                        pw.println(services.getJSONObject(name).getString("path"));
                    }
                }
                catch (JSONException e) {
                    response.setStatus(500);
                    String message = "Error parsing services";
                    if (e.getMessage() != null) {
                        message = e.getMessage();
                    }
                    pw.print("[ERROR] ");
                    pw.println(message);
                }
            } else {
                if (!StringUtils.isEmpty((String)callback)) {
                    pw.write(callback + "(");
                }
                pw.write(services.toString());
                if (!StringUtils.isEmpty((String)callback)) {
                    pw.write(");");
                }
            }
            pw.flush();
        }
    }
}

