/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.webservice.server;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.intermine.api.InterMineAPI;
import org.intermine.metadata.ClassDescriptor;
import org.intermine.metadata.Model;
import org.intermine.pathquery.Path;
import org.intermine.pathquery.PathException;
import org.intermine.web.context.InterMineContext;
import org.intermine.web.logic.config.FieldConfig;
import org.intermine.web.logic.config.FieldConfigHelper;
import org.intermine.web.logic.config.WebConfig;
import org.intermine.webservice.server.core.JSONService;

public class SummaryService
extends JSONService {
    private static final Logger LOG = Logger.getLogger(SummaryService.class);

    public SummaryService(InterMineAPI im) {
        super(im);
    }

    @Override
    protected void execute() throws Exception {
        Boolean refsAllowed = Boolean.valueOf(this.getOptionalParameter("norefs", "false")) == false;
        WebConfig webConfig = InterMineContext.getWebConfig();
        Map<String, Object> summaryFieldsForCd = this.getMapping(refsAllowed, webConfig);
        this.addResultItem(summaryFieldsForCd, false);
    }

    private Map<String, Object> getMapping(Boolean refsAllowed, WebConfig webConfig) {
        HashMap<String, Object> summaryFieldsForCd = new HashMap<String, Object>();
        Model m = this.im.getModel();
        for (ClassDescriptor cd : m.getClassDescriptors()) {
            ArrayList<String> summaryFields = new ArrayList<String>();
            if ("org.intermine.model.InterMineObject".equals(cd.getName())) continue;
            for (FieldConfig fc : FieldConfigHelper.getClassFieldConfigs(webConfig, cd)) {
                try {
                    Path p = new Path(m, cd.getUnqualifiedName() + "." + fc.getFieldExpr());
                    if (!p.endIsAttribute() || p.containsReferences() && !refsAllowed.booleanValue() || !fc.getShowInSummary()) continue;
                    summaryFields.add(p.getNoConstraintsString());
                }
                catch (PathException e) {
                    LOG.warn((Object)"Web config contains a bad path!", (Throwable)e);
                }
            }
            summaryFieldsForCd.put(cd.getUnqualifiedName(), summaryFields);
        }
        return summaryFieldsForCd;
    }

    @Override
    protected String getResultsKey() {
        return "classes";
    }

    @Override
    protected String getDefaultFileName() {
        return "summary_fields.json";
    }
}

