/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.webservice.server.bg;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.HashMap;
import org.intermine.api.InterMineAPI;
import org.intermine.modelproduction.MetadataManager;
import org.intermine.objectstore.ObjectStoreWriter;
import org.intermine.objectstore.intermine.ObjectStoreInterMineImpl;
import org.intermine.sql.Database;
import org.intermine.webservice.server.core.JSONService;
import org.intermine.webservice.server.exceptions.BadRequestException;
import org.intermine.webservice.server.exceptions.ServiceForbiddenException;

public class BGPropertiesCreationService
extends JSONService {
    public BGPropertiesCreationService(InterMineAPI im) {
        super(im);
    }

    @Override
    protected void execute() throws Exception {
        HashMap bgMap;
        if (!this.getPermission().getProfile().isSuperuser()) {
            throw new ServiceForbiddenException("Only admins users can access this service");
        }
        String key = this.getRequiredParameter("key");
        String value = this.getRequiredParameter("value");
        ObjectStoreWriter uosw = this.im.getProfileManager().getProfileObjectStoreWriter();
        String bgPropsAsString = MetadataManager.retrieve((Database)((ObjectStoreInterMineImpl)uosw).getDatabase(), (String)"bgProperties");
        ObjectMapper mapper = new ObjectMapper();
        if (bgPropsAsString == null) {
            bgMap = new HashMap();
        } else {
            bgMap = (HashMap)mapper.readValue(bgPropsAsString, HashMap.class);
            if (bgMap.containsKey(key)) {
                throw new BadRequestException("A property with key " + key + " already exists.");
            }
        }
        bgMap.put(key, value);
        MetadataManager.store((Database)((ObjectStoreInterMineImpl)uosw).getDatabase(), (String)"bgProperties", (String)mapper.writeValueAsString((Object)bgMap));
    }
}

