/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.webservice.server.bg;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.HashMap;
import org.intermine.api.InterMineAPI;
import org.intermine.modelproduction.MetadataManager;
import org.intermine.objectstore.ObjectStoreWriter;
import org.intermine.objectstore.intermine.ObjectStoreInterMineImpl;
import org.intermine.sql.Database;
import org.intermine.webservice.server.core.JSONService;
import org.intermine.webservice.server.exceptions.ResourceNotFoundException;
import org.intermine.webservice.server.exceptions.ServiceForbiddenException;

public class BGPropertiesDelationService
extends JSONService {
    public BGPropertiesDelationService(InterMineAPI im) {
        super(im);
    }

    @Override
    protected void execute() throws Exception {
        if (!this.getPermission().getProfile().isSuperuser()) {
            throw new ServiceForbiddenException("Only admins users can access this service");
        }
        String key = this.getRequiredParameter("key");
        ObjectStoreWriter uosw = this.im.getProfileManager().getProfileObjectStoreWriter();
        String bgPropsAsString = MetadataManager.retrieve((Database)((ObjectStoreInterMineImpl)uosw).getDatabase(), (String)"bgProperties");
        ObjectMapper mapper = new ObjectMapper();
        if (bgPropsAsString == null) {
            throw new ResourceNotFoundException("A property with key " + key + " doesn't exists.");
        }
        HashMap bgMap = (HashMap)mapper.readValue(bgPropsAsString, HashMap.class);
        if (bgMap.remove(key) == null) {
            throw new ResourceNotFoundException("A property with key " + key + " doesn't exists.");
        }
        MetadataManager.store((Database)((ObjectStoreInterMineImpl)uosw).getDatabase(), (String)"bgProperties", (String)mapper.writeValueAsString((Object)bgMap));
    }
}

