/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.webservice.server.bg;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.HashMap;
import org.intermine.api.InterMineAPI;
import org.intermine.modelproduction.MetadataManager;
import org.intermine.objectstore.ObjectStoreWriter;
import org.intermine.objectstore.intermine.ObjectStoreInterMineImpl;
import org.intermine.sql.Database;
import org.intermine.webservice.server.core.JSONService;
import org.intermine.webservice.server.exceptions.ResourceNotFoundException;

public class BGPropertiesService
extends JSONService {
    public BGPropertiesService(InterMineAPI im) {
        super(im);
    }

    @Override
    protected void execute() throws Exception {
        String key = this.getOptionalParameter("key");
        ObjectStoreWriter uosw = this.im.getProfileManager().getProfileObjectStoreWriter();
        String bgPropsAsString = MetadataManager.retrieve((Database)((ObjectStoreInterMineImpl)uosw).getDatabase(), (String)"bgProperties");
        if (bgPropsAsString == null) {
            this.addResultEntry("bluegenes-properties", new HashMap(), false);
        } else {
            ObjectMapper mapper = new ObjectMapper();
            HashMap bgMap = (HashMap)mapper.readValue(bgPropsAsString, HashMap.class);
            if (key == null) {
                this.addResultEntry("bluegenes-properties", bgMap, false);
            } else {
                String value = (String)bgMap.get(key);
                if (value == null) {
                    throw new ResourceNotFoundException("A property with key " + key + " doesn't exists.");
                }
                this.addResultEntry("bluegenes-properties", new HashMap<String, String>().put(key, value), false);
            }
        }
    }
}

