/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.webservice.server.clob;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.intermine.api.InterMineAPI;
import org.intermine.api.bag.BagQueryRunner;
import org.intermine.api.query.MainHelper;
import org.intermine.model.FastPathObject;
import org.intermine.objectstore.ObjectStoreException;
import org.intermine.objectstore.query.Query;
import org.intermine.pathquery.Path;
import org.intermine.pathquery.PathException;
import org.intermine.pathquery.PathQuery;
import org.intermine.webservice.server.core.JSONService;
import org.intermine.webservice.server.exceptions.BadRequestException;
import org.intermine.webservice.server.exceptions.NotImplementedException;
import org.intermine.webservice.server.exceptions.ServiceException;
import org.intermine.webservice.server.query.AbstractQueryService;
import org.intermine.webservice.server.query.QueryRequestParser;
import org.intermine.webservice.server.query.result.PathQueryBuilder;

public class SequenceService
extends JSONService {
    private static final String EXPECTED_CHAR_SEQUENCE = "Expected the column to provide a CharSequence value, got: ";

    public SequenceService(InterMineAPI im) {
        super(im);
    }

    @Override
    protected Map<String, Object> getHeaderAttributes() {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        attributes.putAll(super.getHeaderAttributes());
        if (this.formatIsJSON()) {
            attributes.put("intro", "\"features\":[");
            attributes.put("outro", "]");
        }
        return attributes;
    }

    @Override
    protected void execute() {
        Integer start = this.getIntParameter("start", 0);
        Integer end = this.getIntParameter("end", null);
        PathQuery pq = this.getQuery();
        Iterator<CharSequence> sequences = this.getSequences(pq);
        while (sequences.hasNext()) {
            CharSequence chars = sequences.next();
            this.addResultItem(this.makeFeature(chars, start, end), sequences.hasNext());
        }
    }

    private Iterator<CharSequence> getSequences(final PathQuery pq) {
        Query q;
        this.validateQuery(pq);
        BagQueryRunner bqr = this.im.getBagQueryRunner();
        try {
            q = MainHelper.makeQuery((PathQuery)pq, this.getListManager().getListMap(), new HashMap(), (BagQueryRunner)bqr, new HashMap());
        }
        catch (ObjectStoreException e) {
            throw new ServiceException(e);
        }
        final Iterator results = this.im.getObjectStore().executeSingleton(q).iterator();
        return new Iterator<CharSequence>(){

            @Override
            public boolean hasNext() {
                return results.hasNext();
            }

            @Override
            public CharSequence next() {
                CharSequence chars;
                FastPathObject obj = (FastPathObject)results.next();
                try {
                    chars = (CharSequence)obj.getFieldValue(pq.makePath((String)pq.getView().get(0)).getEndFieldDescriptor().getName());
                }
                catch (IllegalAccessException e) {
                    throw new ServiceException(e);
                }
                catch (PathException e) {
                    throw new ServiceException(e);
                }
                return chars;
            }

            @Override
            public void remove() {
                throw new NotImplementedException(this.getClass(), "remove");
            }
        };
    }

    private void validateQuery(PathQuery pq) {
        Path column;
        List view = pq.getView();
        if (view.size() != 1) {
            throw new BadRequestException("Expected only a single view column, got: " + view);
        }
        try {
            column = pq.makePath((String)view.get(0));
        }
        catch (PathException e) {
            throw new BadRequestException(e);
        }
        if (!CharSequence.class.isAssignableFrom(column.getEndType())) {
            throw new BadRequestException(EXPECTED_CHAR_SEQUENCE + column.getEndType());
        }
    }

    private Map<String, Object> makeFeature(CharSequence chars, Integer start, Integer end) {
        CharSequence subSequence;
        try {
            subSequence = end == null ? chars.subSequence(start, chars.length()) : chars.subSequence(start, end);
        }
        catch (IndexOutOfBoundsException e) {
            throw new BadRequestException("Illegal start/end values: " + e.getMessage());
        }
        HashMap<String, Object> feat = new HashMap<String, Object>();
        feat.put("start", start);
        feat.put("end", subSequence.length() + start);
        feat.put("seq", String.valueOf(subSequence));
        return feat;
    }

    private PathQuery getQuery() {
        String query = new QueryRequestParser(this.im.getQueryStore(), this.request).getQueryXml();
        String schemaUrl = AbstractQueryService.getSchemaLocation(this.request, "XML");
        if (!query.startsWith("<")) {
            schemaUrl = AbstractQueryService.getSchemaLocation(this.request, "JSON");
        }
        PathQueryBuilder bdr = new PathQueryBuilder(this.im, query, schemaUrl, this.getListManager());
        return bdr.getQuery();
    }
}

