/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.webservice.server.core;

import java.util.ArrayList;
import java.util.List;
import org.intermine.webservice.server.core.DisjointList;
import org.intermine.webservice.server.core.Either;
import org.intermine.webservice.server.core.EitherVisitor;
import org.intermine.webservice.server.core.F;

class DisjointRecursiveList<T> {
    DisjointList<T, DisjointRecursiveList<T>> items = new DisjointList();

    DisjointRecursiveList() {
    }

    void addList(DisjointRecursiveList<T> subs) {
        this.items.addRight(subs);
    }

    void addNode(T node) {
        this.items.addLeft(node);
    }

    public String toString() {
        return String.valueOf(this.items);
    }

    public List<T> flatten() {
        final ArrayList flattened = new ArrayList();
        this.forEach(new Eacher<T>(){

            @Override
            public Void visitLeft(T a) {
                flattened.add(a);
                return null;
            }

            @Override
            public Void visitRight(DisjointRecursiveList<T> b) {
                flattened.addAll(b.flatten());
                return null;
            }
        });
        return flattened;
    }

    <X> DisjointRecursiveList<X> fmap(final F<T, X> mapFn) {
        final DisjointRecursiveList<T> retVal = new DisjointRecursiveList<T>();
        this.forEach(new EitherVisitor<T, DisjointRecursiveList<T>, Void>(){

            @Override
            public Void visitLeft(T a) {
                retVal.addNode(mapFn.call(a));
                return null;
            }

            @Override
            public Void visitRight(DisjointRecursiveList<T> b) {
                retVal.addList(b.fmap(mapFn));
                return null;
            }
        });
        return retVal;
    }

    void forEach(EitherVisitor<T, DisjointRecursiveList<T>, Void> visitor) {
        for (Either either : this.items) {
            either.accept(visitor);
        }
    }

    public static abstract class Eacher<T>
    extends EitherVisitor<T, DisjointRecursiveList<T>, Void> {
    }
}

