/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.webservice.server.core;

import org.intermine.webservice.server.core.EitherVisitor;

public abstract class Either<A, B> {
    private Either() {
    }

    public abstract int hashCode();

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof Either)) {
            return false;
        }
        Either rhs = (Either)obj;
        return (Boolean)this.accept(new EqualityVisitor(rhs));
    }

    public abstract <T> T accept(EitherVisitor<A, B, T> var1);

    public static final class Right<A, B>
    extends Either<A, B> {
        private final B b;

        public Right(B b) {
            this.b = b;
        }

        @Override
        public <T> T accept(EitherVisitor<A, B, T> visitor) {
            return visitor.visitRight(this.b);
        }

        public String toString() {
            return String.format("Right(%s)", this.b);
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.b == null ? 0 : this.b.hashCode());
            return result;
        }
    }

    public static final class Left<A, B>
    extends Either<A, B> {
        private final A a;

        @Override
        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.a == null ? 0 : this.a.hashCode());
            return result;
        }

        public Left(A a) {
            this.a = a;
        }

        @Override
        public <T> T accept(EitherVisitor<A, B, T> visitor) {
            return visitor.visitLeft(this.a);
        }

        public String toString() {
            return String.format("Left(%s)", this.a);
        }
    }

    private final class EqualityVisitor
    extends EitherVisitor<A, B, Boolean> {
        private final Either<A, B> rhs;

        private EqualityVisitor(Either<A, B> rhs) {
            this.rhs = rhs;
        }

        @Override
        public Boolean visitLeft(A a1) {
            return (Boolean)this.rhs.accept(new AEqualsA(a1));
        }

        @Override
        public Boolean visitRight(B b1) {
            return (Boolean)this.rhs.accept(new BEqualsB(b1));
        }

        private final class AEqualsA
        extends EitherVisitor<A, B, Boolean> {
            private final A a1;

            private AEqualsA(A a1) {
                this.a1 = a1;
            }

            @Override
            public Boolean visitLeft(A a2) {
                return this.a1 == null && a2 == null || this.a1.equals(a2);
            }

            @Override
            public Boolean visitRight(B b) {
                return false;
            }
        }

        private final class BEqualsB
        extends EitherVisitor<A, B, Boolean> {
            private final B b1;

            private BEqualsB(B b1) {
                this.b1 = b1;
            }

            @Override
            public Boolean visitLeft(A a) {
                return false;
            }

            @Override
            public Boolean visitRight(B b2) {
                return this.b1 == null && b2 == null || this.b1.equals(b2);
            }
        }
    }
}

