/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.webservice.server.core;

import org.intermine.webservice.server.core.Either;
import org.intermine.webservice.server.core.Function;

public abstract class EitherVisitor<A, B, T>
implements Function<Either<A, B>, T> {
    public abstract T visitLeft(A var1);

    public abstract T visitRight(B var1);

    @Override
    public T call(Either<A, B> either) {
        return either.accept(this);
    }

    public <R> EitherVisitor<A, B, R> and(final EitherVisitor<A, B, R> next) {
        final EitherVisitor outer = this;
        return new EitherVisitor<A, B, R>(){

            @Override
            public R visitLeft(A a) {
                outer.visitLeft(a);
                return next.visitLeft(a);
            }

            @Override
            public R visitRight(B b) {
                outer.visitRight(b);
                return next.visitRight(b);
            }
        };
    }

    public <R> EitherVisitor<A, B, R> then(final Function<T, R> fn) {
        final EitherVisitor outer = this;
        return new EitherVisitor<A, B, R>(){

            @Override
            public R visitLeft(A a) {
                return fn.call(outer.visitLeft(a));
            }

            @Override
            public R visitRight(B b) {
                return fn.call(outer.visitRight(b));
            }
        };
    }
}

