/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.webservice.server.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringEscapeUtils;
import org.intermine.api.InterMineAPI;
import org.intermine.api.bag.BagManager;
import org.intermine.metadata.Model;
import org.intermine.webservice.server.Format;
import org.intermine.webservice.server.WebService;
import org.intermine.webservice.server.core.Pair;
import org.json.JSONArray;
import org.json.JSONObject;

public abstract class JSONService
extends WebService {
    protected final BagManager bagManager;
    protected final Model model;
    private final Map<String, String> kvPairs = new HashMap<String, String>();

    public JSONService(InterMineAPI im) {
        super(im);
        this.bagManager = im.getBagManager();
        this.model = im.getObjectStore().getModel();
    }

    @Override
    protected void postInit() {
        this.output.setHeaderAttributes(this.getHeaderAttributes());
    }

    protected String getResultsKey() {
        return null;
    }

    protected boolean lazyList() {
        return false;
    }

    protected Map<String, Object> getHeaderAttributes() {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        String resultsKey = this.getResultsKey();
        if (resultsKey != null) {
            String intro = "\"" + resultsKey + "\":";
            if (this.lazyList()) {
                intro = intro + "[";
                attributes.put("outro", "]");
            }
            attributes.put("intro", intro);
        }
        if (this.formatIsJSONP()) {
            attributes.put("callback", this.getCallback());
        }
        attributes.put("key_value_pairs", this.kvPairs);
        return attributes;
    }

    protected void addOutputInfo(String key, String value) {
        this.kvPairs.put(key, value);
    }

    protected void addResultItem(Map<String, ? extends Object> mapping, boolean hasMore) {
        JSONObject jo = new JSONObject(mapping);
        this.addResultItemInternal(jo, hasMore);
    }

    protected void addResultValue(CharSequence str, boolean hasMore) {
        this.addResultItemInternal("\"" + String.valueOf(str) + "\"", hasMore);
    }

    protected void addResultValue(Number num, boolean hasMore) {
        this.addResultValueInternal(String.valueOf(num), hasMore);
    }

    protected void addResultValue(Boolean bool, boolean hasMore) {
        this.addResultValueInternal(String.valueOf(bool), hasMore);
    }

    private void addResultValueInternal(String val, boolean hasMore) {
        ArrayList<String> outputStrings = new ArrayList<String>();
        outputStrings.add(val);
        if (hasMore) {
            outputStrings.add("");
        }
        this.output.addResultItem(outputStrings);
    }

    protected void addResultEntries(Collection<Map.Entry<String, Object>> entries) {
        this.addResultEntries(entries, false);
    }

    protected void addResultEntry(String key, Object value, boolean hasMore) {
        this.addResultEntry(new Pair<String, Object>(key, value), hasMore);
    }

    protected void addResultEntry(Map.Entry<String, Object> entry, boolean hasMore) {
        this.addResultEntries(Collections.singleton(entry), hasMore);
    }

    protected void addResultEntries(Collection<Map.Entry<String, Object>> entries, boolean hasMore) {
        ArrayList<String> outputStrings = new ArrayList<String>();
        for (Map.Entry<String, Object> entry : entries) {
            String key = entry.getKey();
            Object value = entry.getValue();
            String valStr = null;
            if (value == null) {
                valStr = "null";
            } else if (value instanceof Map) {
                valStr = new JSONObject((Map)value).toString();
            } else if (value instanceof List) {
                valStr = new JSONArray((Collection)((List)value)).toString();
            } else if (value instanceof CharSequence) {
                valStr = String.format("\"%s\"", StringEscapeUtils.escapeJava((String)String.valueOf(value)));
            } else if (value instanceof Number || value instanceof Boolean) {
                valStr = String.valueOf(value);
            }
            outputStrings.add(String.format("\"%s\":%s", key, valStr));
        }
        if (hasMore) {
            outputStrings.add("");
        }
        this.output.addResultItem(outputStrings);
    }

    protected void addResultItem(List<? extends Object> listing, boolean hasMore) {
        JSONArray ja = new JSONArray(listing);
        this.addResultItemInternal(ja, hasMore);
    }

    private void addResultItemInternal(Object obj, boolean hasMore) {
        ArrayList<String> outputStrings = new ArrayList<String>();
        outputStrings.add(String.valueOf(obj));
        if (hasMore) {
            outputStrings.add("");
        }
        this.output.addResultItem(outputStrings);
    }

    @Override
    protected Format getDefaultFormat() {
        return Format.JSON;
    }
}

