/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.webservice.server.core;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import org.apache.commons.lang.StringUtils;
import org.intermine.api.InterMineAPI;
import org.intermine.webservice.server.WebService;
import org.intermine.webservice.server.core.NoServiceException;
import org.intermine.webservice.server.core.WebServiceServlet;

public class RestfulServlet
extends WebServiceServlet {
    private static final long serialVersionUID = -6545928555512220185L;
    private Map<WebServiceServlet.Method, Constructor<? extends WebService>> mapping = new HashMap<WebServiceServlet.Method, Constructor<? extends WebService>>();

    public void init() throws ServletException {
        super.init();
        for (WebServiceServlet.Method method : WebServiceServlet.Method.values()) {
            String className = this.getInitParameter(method.name());
            if (!StringUtils.isNotBlank((String)className)) continue;
            this.mapping.put(method, this.getConstructor(className));
        }
        if (this.mapping.isEmpty()) {
            throw new ServletException("No supported methods");
        }
    }

    private Constructor<? extends WebService> getConstructor(String className) throws ServletException {
        Class<?> serviceClass;
        try {
            serviceClass = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new ServletException("Could not find " + className, (Throwable)e);
        }
        try {
            return serviceClass.getConstructor(InterMineAPI.class);
        }
        catch (SecurityException e) {
            throw new ServletException((Throwable)e);
        }
        catch (NoSuchMethodException e) {
            throw new ServletException((Throwable)e);
        }
    }

    @Override
    protected WebService getService(WebServiceServlet.Method method) throws NoServiceException {
        if (this.mapping.containsKey((Object)method)) {
            try {
                return this.mapping.get((Object)method).newInstance(this.api);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
            catch (InstantiationException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        throw new NoServiceException();
    }
}

