/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.webservice.server.core;

import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.intermine.api.results.ResultElement;
import org.intermine.pathquery.ConstraintValueParser;
import org.intermine.webservice.server.output.Output;

public class ResultProcessor {
    public void write(Iterator<List<ResultElement>> resultIt, Output output) {
        while (resultIt.hasNext()) {
            List<ResultElement> row = resultIt.next();
            output.addResultItem(ResultProcessor.convertResultElementsToStrings(row));
        }
    }

    private static List<String> convertResultElementsToStrings(List<ResultElement> row) {
        ArrayList<String> ret = new ArrayList<String>();
        for (ResultElement el : row) {
            String value = el != null && el.getField() != null ? (el.getField() instanceof Date ? ConstraintValueParser.ISO_DATE_FORMAT.format(el.getField()) : el.getField().toString()) : "";
            ret.add(value);
        }
        return ret;
    }
}

