/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.webservice.server.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.intermine.api.InterMineAPI;
import org.intermine.api.results.ResultCell;
import org.intermine.metadata.TypeUtil;
import org.intermine.model.FastPathObject;
import org.intermine.objectstore.query.PathExpressionField;
import org.intermine.objectstore.query.Query;
import org.intermine.objectstore.query.QueryCollectionPathExpression;
import org.intermine.objectstore.query.QueryObjectPathExpression;
import org.intermine.objectstore.query.QuerySelectable;
import org.intermine.objectstore.query.Results;
import org.intermine.pathquery.Path;
import org.intermine.pathquery.PathException;
import org.intermine.pathquery.PathQuery;
import org.intermine.util.DynamicUtil;
import org.intermine.webservice.server.core.DisjointList;
import org.intermine.webservice.server.core.DisjointRecursiveList;
import org.intermine.webservice.server.core.Either;
import org.intermine.webservice.server.core.EitherVisitor;
import org.intermine.webservice.server.core.Page;
import org.intermine.webservice.server.core.SubTable;
import org.intermine.webservice.server.core.TableCell;
import org.intermine.webservice.server.core.TreeWalker;
import org.intermine.webservice.server.exceptions.NotImplementedException;

public class TableRowIterator
implements Iterator<List<Either<ResultCell, SubTable>>>,
Iterable<List<Either<ResultCell, SubTable>>> {
    private static final String EXPECTED_SUBTABLE = "Expected this result element to be a subtable of the form %s, but was %s";
    private static final String NOT_INTERMINE_OBJECT = "Table row iteration only supported over InterMine Objects, not %s instances. Got %s";
    private static final Logger LOG = Logger.getLogger(TableRowIterator.class);
    private final PathQuery pathQuery;
    private final Query query;
    private final Results results;
    private final Map<String, QuerySelectable> nodeForPath = new HashMap<String, QuerySelectable>();
    private final List<Path> paths = new ArrayList<Path>();
    private final Page page;
    private final InterMineAPI im;
    private DisjointRecursiveList<List<Path>> resultsShape;
    private final List<Path> effectiveView = new ArrayList<Path>();
    private int counter = 0;
    private Path root;
    private Iterator<Object> osIter;
    private Map<DisjointRecursiveList<List<Path>>, Path> levels;
    private static final EitherVisitor<ResultCell, SubTable, Path> PATH_GETTER = new EitherVisitor<ResultCell, SubTable, Path>(){

        @Override
        public Path visitLeft(ResultCell a) {
            return a.getPath();
        }

        @Override
        public Path visitRight(SubTable b) {
            return b.getJoinPath();
        }
    };
    private Comparator<Either<ResultCell, SubTable>> reorderer;
    private Comparator<Either<Path, DisjointRecursiveList<Path>>> pathReorderer;

    public TableRowIterator(PathQuery pathQuery, Query query, Results results, Map<String, QuerySelectable> nodeForPath, Page page, InterMineAPI im) {
        this.page = page;
        this.query = query;
        this.pathQuery = pathQuery;
        this.results = results;
        this.nodeForPath.putAll(nodeForPath);
        this.im = im;
        try {
            this.init();
        }
        catch (PathException e) {
            throw new RuntimeException("Failed to initialise", e);
        }
    }

    private void init() throws PathException {
        this.osIter = this.results.iteratorFrom(this.page.getStart());
        this.counter = this.page.getStart();
        this.root = this.pathQuery.makePath(this.pathQuery.getRootClass());
        for (String view : this.pathQuery.getView()) {
            this.paths.add(this.pathQuery.makePath(view));
        }
        ColumnConversionInput cci = new ColumnConversionInput();
        cci.paths = this.paths;
        cci.pathToQueryNode = this.nodeForPath;
        cci.select = new ArrayList<QuerySelectable>(this.query.getSelect());
        this.resultsShape = this.determineResultShape(cci);
        this.levels = this.getLevelMap(this.resultsShape);
        this.levels.put(this.resultsShape, this.root);
        this.reorderer = new Comparator<Either<ResultCell, SubTable>>(){

            private Integer pathToViewIndex(Path path) {
                String pString;
                String view = pString = path.toStringNoConstraints();
                if (!path.endIsAttribute()) {
                    for (String v : TableRowIterator.this.pathQuery.getView()) {
                        if (!v.startsWith(pString)) continue;
                        view = v;
                        break;
                    }
                }
                return TableRowIterator.this.pathQuery.getView().indexOf(view);
            }

            @Override
            public int compare(Either<ResultCell, SubTable> o1, Either<ResultCell, SubTable> o2) {
                Path path1 = (Path)o1.accept(PATH_GETTER);
                Path path2 = (Path)o2.accept(PATH_GETTER);
                return this.pathToViewIndex(path1).compareTo(this.pathToViewIndex(path2));
            }
        };
        this.pathReorderer = new Comparator<Either<Path, DisjointRecursiveList<Path>>>(){
            private EitherVisitor<Path, DisjointRecursiveList<Path>, Integer> toViewIndex = new EitherVisitor<Path, DisjointRecursiveList<Path>, Integer>(){

                @Override
                public Integer visitLeft(Path a) {
                    return TableRowIterator.this.pathQuery.getView().indexOf(a.toStringNoConstraints());
                }

                @Override
                public Integer visitRight(DisjointRecursiveList<Path> b) {
                    return TableRowIterator.this.pathQuery.getView().indexOf(b.flatten().get(0).toStringNoConstraints());
                }
            };

            @Override
            public int compare(Either<Path, DisjointRecursiveList<Path>> o1, Either<Path, DisjointRecursiveList<Path>> o2) {
                return o1.accept(this.toViewIndex).compareTo(o2.accept(this.toViewIndex));
            }
        };
        this.effectiveView.addAll(this.determineEffectiveView());
    }

    public List<Path> getEffectiveView() {
        return Collections.unmodifiableList(this.effectiveView);
    }

    private DisjointRecursiveList<Path> consolidateLevels(DisjointRecursiveList<List<Path>> shape) {
        final DisjointRecursiveList<Path> consolidated = new DisjointRecursiveList<Path>();
        shape.forEach((EitherVisitor<List<Path>, DisjointRecursiveList<List<Path>>, Void>)new DisjointRecursiveList.Eacher<List<Path>>(){

            @Override
            public Void visitLeft(List<Path> a) {
                for (Path p : a) {
                    consolidated.addNode(p);
                }
                return null;
            }

            @Override
            public Void visitRight(DisjointRecursiveList<List<Path>> b) {
                consolidated.addList(TableRowIterator.this.consolidateLevels(b));
                return null;
            }
        });
        return consolidated;
    }

    private void orderListOnEachLevel(DisjointRecursiveList<Path> consolidated) {
        consolidated.forEach((EitherVisitor<Path, DisjointRecursiveList<Path>, Void>)new DisjointRecursiveList.Eacher<Path>(){

            @Override
            public Void visitLeft(Path a) {
                return null;
            }

            @Override
            public Void visitRight(DisjointRecursiveList<Path> b) {
                TableRowIterator.this.orderListOnEachLevel(b);
                return null;
            }
        });
        Collections.sort(consolidated.items, this.pathReorderer);
    }

    private List<Path> determineEffectiveView() {
        DisjointRecursiveList<Path> consolidated = this.consolidateLevels(this.resultsShape);
        this.orderListOnEachLevel(consolidated);
        return consolidated.flatten();
    }

    private Map<DisjointRecursiveList<List<Path>>, Path> getLevelMap(DisjointRecursiveList<List<Path>> shape) {
        HashMap<DisjointRecursiveList<List<Path>>, Path> retVal = new HashMap<DisjointRecursiveList<List<Path>>, Path>();
        this.determineLevels(shape, retVal);
        return retVal;
    }

    private Path determineLevels(DisjointRecursiveList<List<Path>> shape, final Map<DisjointRecursiveList<List<Path>>, Path> shapeToLevel) {
        final HashSet pathsAtThisLevel = new HashSet();
        final ArrayList pathsBelowThisLevel = new ArrayList();
        if (shape.items.isEmpty()) {
            return null;
        }
        shape.forEach((EitherVisitor<List<Path>, DisjointRecursiveList<List<Path>>, Void>)new TreeWalker<List<Path>>(){

            @Override
            public Void visitLeft(List<Path> views) {
                pathsAtThisLevel.addAll(views);
                return null;
            }

            @Override
            public Void visitRight(DisjointRecursiveList<List<Path>> b) {
                pathsBelowThisLevel.add(TableRowIterator.this.determineLevels(b, shapeToLevel));
                return null;
            }
        });
        Path retVal = null;
        try {
            if (!pathsAtThisLevel.isEmpty()) {
                Path oneOfThisLevel = (Path)pathsAtThisLevel.iterator().next();
                retVal = this.getOJG(oneOfThisLevel);
            } else if (!pathsBelowThisLevel.isEmpty()) {
                Path oneBelowThisLevel = (Path)pathsBelowThisLevel.iterator().next();
                retVal = this.getOJG(oneBelowThisLevel.getPrefix());
            } else {
                throw new RuntimeException("no paths found in this shape: " + shape);
            }
            while (!retVal.endIsCollection() && !retVal.isRootPath()) {
                retVal = this.getOJG(retVal.getPrefix());
            }
        }
        catch (PathException e) {
            throw new RuntimeException("This should never have happened.", e);
        }
        shapeToLevel.put(shape, retVal);
        return retVal;
    }

    private Path getOJG(Path somePath) throws PathException {
        return this.pathQuery.makePath(this.pathQuery.getOuterJoinGroup(somePath.getNoConstraintsString()));
    }

    /*
     * WARNING - void declaration
     */
    private DisjointRecursiveList<List<Path>> determineResultShape(ColumnConversionInput cci) {
        DisjointRecursiveList<List<Path>> retval = new DisjointRecursiveList<List<Path>>();
        for (QuerySelectable querySelectable : cci.select) {
            List subSelect;
            void var4_4;
            boolean done = false;
            while (!done) {
                if (var4_4 instanceof QueryObjectPathExpression) {
                    QueryObjectPathExpression qope = (QueryObjectPathExpression)var4_4;
                    subSelect = qope.getSelect();
                    if (!subSelect.isEmpty()) {
                        QuerySelectable querySelectable2 = (QuerySelectable)subSelect.get(0);
                        if (!querySelectable2.equals(qope.getDefaultClass())) continue;
                        QueryObjectPathExpression queryObjectPathExpression = qope;
                        done = true;
                        continue;
                    }
                    done = true;
                    continue;
                }
                if (var4_4 instanceof PathExpressionField) {
                    PathExpressionField pef = (PathExpressionField)var4_4;
                    QueryObjectPathExpression qope = pef.getQope();
                    QuerySelectable querySelectable3 = (QuerySelectable)qope.getSelect().get(pef.getFieldNumber());
                    if (!querySelectable3.equals(qope.getDefaultClass())) continue;
                    QueryObjectPathExpression queryObjectPathExpression = qope;
                    done = true;
                    continue;
                }
                done = true;
            }
            if (var4_4 instanceof QueryCollectionPathExpression) {
                QueryCollectionPathExpression qc = (QueryCollectionPathExpression)var4_4;
                subSelect = qc.getSelect();
                if (subSelect.isEmpty()) {
                    subSelect = Collections.singletonList(qc.getDefaultClass());
                }
                retval.addList(this.determineResultShape(cci.getNextLevelInput(subSelect)));
                continue;
            }
            LinkedList<Path> fieldsForObject = new LinkedList<Path>();
            for (Path path : cci.paths) {
                Path parent = path.getPrefix();
                QuerySelectable selectableForPath = cci.pathToQueryNode.get(parent.toStringNoConstraints());
                if (selectableForPath instanceof QueryCollectionPathExpression) {
                    selectableForPath = ((QueryCollectionPathExpression)selectableForPath).getDefaultClass();
                }
                if (!var4_4.equals(selectableForPath)) continue;
                fieldsForObject.add(path);
            }
            if (fieldsForObject.isEmpty()) {
                LOG.error((Object)("Couldn't find any paths for " + var4_4 + " from amongst " + cci.paths));
            }
            retval.addNode(fieldsForObject);
        }
        return retval;
    }

    @Override
    public Iterator<List<Either<ResultCell, SubTable>>> iterator() {
        return new TableRowIterator(this.pathQuery, this.query, this.results, this.nodeForPath, this.page, this.im);
    }

    @Override
    public boolean hasNext() {
        return this.page.withinRange(this.counter) && this.osIter.hasNext();
    }

    @Override
    public void remove() {
        throw new NotImplementedException(this.getClass(), "remove");
    }

    @Override
    public List<Either<ResultCell, SubTable>> next() {
        List row = (List)this.osIter.next();
        ++this.counter;
        return this.recursiveNext(row, this.resultsShape);
    }

    private List<Either<ResultCell, SubTable>> recursiveNext(List row, DisjointRecursiveList<List<Path>> shape) {
        final DisjointList<ResultCell, SubTable> retVal = new DisjointList<ResultCell, SubTable>();
        final Iterator iter = row.iterator();
        shape.forEach((EitherVisitor<List<Path>, DisjointRecursiveList<List<Path>>, Void>)new TreeWalker<List<Path>>(){

            @Override
            public Void visitLeft(List<Path> views) {
                Object o = iter.next();
                if (o == null) {
                    for (Path p : views) {
                        retVal.addLeft(new TableCell(p));
                    }
                } else if (o instanceof FastPathObject) {
                    FastPathObject fpo = (FastPathObject)o;
                    for (Path p : views) {
                        List keyFields;
                        String cls = TypeUtil.unqualifiedName((String)DynamicUtil.getSimpleClassName(o.getClass()));
                        boolean isKeyField = false;
                        if (TableRowIterator.this.im != null && (keyFields = (List)TableRowIterator.this.im.getClassKeys().get((Object)cls)) != null) {
                            isKeyField = keyFields.contains(p.getEndFieldDescriptor());
                        }
                        retVal.addLeft(new TableCell(fpo, p, isKeyField));
                    }
                } else {
                    throw new RuntimeException(String.format(TableRowIterator.NOT_INTERMINE_OBJECT, o.getClass().getName(), o));
                }
                return null;
            }

            @Override
            public Void visitRight(DisjointRecursiveList<List<Path>> b) {
                Object o = iter.next();
                if (o != null && !(o instanceof List)) {
                    throw new RuntimeException(String.format(TableRowIterator.EXPECTED_SUBTABLE, b, o));
                }
                ArrayList<List<Either<ResultCell, SubTable>>> data = new ArrayList<List<Either<ResultCell, SubTable>>>();
                if (o != null) {
                    List ol = (List)o;
                    for (Object elem : ol) {
                        data.add(TableRowIterator.this.recursiveNext((List)elem, b));
                    }
                }
                final ArrayList<Path> columns = new ArrayList<Path>();
                b.forEach((EitherVisitor<List<Path>, DisjointRecursiveList<List<Path>>, Void>)new TreeWalker<List<Path>>(){

                    @Override
                    public Void visitLeft(List<Path> views) {
                        columns.addAll(views);
                        return null;
                    }

                    @Override
                    public Void visitRight(DisjointRecursiveList<List<Path>> b) {
                        return null;
                    }
                });
                retVal.addRight(new SubTable((Path)TableRowIterator.this.levels.get(b), columns, data));
                return null;
            }
        });
        Collections.sort(retVal, this.reorderer);
        return retVal;
    }

    private class ColumnConversionInput {
        List<? extends QuerySelectable> select;
        Map<String, QuerySelectable> pathToQueryNode;
        List<Path> paths;

        private ColumnConversionInput() {
        }

        ColumnConversionInput getNextLevelInput(List<? extends QuerySelectable> newSelect) {
            ColumnConversionInput cci = new ColumnConversionInput();
            cci.paths = this.paths;
            cci.pathToQueryNode = this.pathToQueryNode;
            cci.select = newSelect;
            return cci;
        }
    }
}

