/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.webservice.server.core;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.intermine.api.InterMineAPI;
import org.intermine.web.context.InterMineContext;
import org.intermine.webservice.server.WebService;
import org.intermine.webservice.server.core.NoServiceException;

public abstract class WebServiceServlet
extends HttpServlet {
    private static final long serialVersionUID = 3419034521176834088L;
    protected final InterMineAPI api = InterMineContext.getInterMineAPI();

    protected void respond(Method method, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            WebService service = this.getService(method);
            if (service == null) {
                throw new NoServiceException();
            }
            service.service(request, response);
        }
        catch (NoServiceException e) {
            this.sendNoMethodError(method.toString(), request, response);
        }
    }

    private void sendNoMethodError(String method, HttpServletRequest request, HttpServletResponse response) throws IOException {
        String protocol = request.getProtocol();
        String msg = "The " + method + " method is not supported";
        if (protocol.endsWith("1.1")) {
            response.sendError(405, msg);
        } else {
            response.sendError(400, msg);
        }
    }

    protected abstract WebService getService(Method var1) throws NoServiceException;

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String tunnelledMethod = request.getParameter("method");
        if (tunnelledMethod != null && !"".equals(tunnelledMethod.trim())) {
            Method tm;
            try {
                tm = Method.valueOf(tunnelledMethod);
            }
            catch (IllegalArgumentException e) {
                this.sendNoMethodError(tunnelledMethod, request, response);
                return;
            }
            this.respond(tm, request, response);
        } else {
            this.respond(Method.GET, request, response);
        }
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if ("PUT".equals(request.getParameter("method"))) {
            this.doPut(request, response);
        } else {
            this.respond(Method.POST, request, response);
        }
    }

    public void doPut(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.respond(Method.PUT, request, response);
    }

    public void doDelete(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.respond(Method.DELETE, request, response);
    }

    public static enum Method {
        GET,
        POST,
        PUT,
        DELETE;

    }
}

