/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.webservice.server.entity;

import java.io.OutputStream;
import java.io.PrintWriter;
import org.intermine.api.InterMineAPI;
import org.intermine.web.logic.export.ResponseUtil;
import org.intermine.web.logic.results.RDFObject;
import org.intermine.web.uri.InterMineLUI;
import org.intermine.webservice.server.Format;
import org.intermine.webservice.server.core.JSONService;
import org.intermine.webservice.server.exceptions.BadRequestException;
import org.intermine.webservice.server.exceptions.ResourceNotFoundException;

public class EntityRepresentationService
extends JSONService {
    public EntityRepresentationService(InterMineAPI im) {
        super(im);
    }

    @Override
    protected void execute() throws Exception {
        String luiInput = this.getRequiredParameter("lui");
        InterMineLUI lui = new InterMineLUI("/" + luiInput);
        String type = this.getRequiredParameter("format");
        if (!type.equalsIgnoreCase("rdf")) {
            throw new BadRequestException("Only rdf format has been implemented");
        }
        RDFObject rdfObject = new RDFObject(lui, this.im, this.request);
        if (!rdfObject.isValid()) {
            this.output = this.makeJSONOutput(this.out, this.getLineBreak());
            String filename = this.getRequestFileName() + ".json";
            ResponseUtil.setJSONHeader(this.response, filename, this.formatIsJSONP());
            throw new ResourceNotFoundException("The lui doesn't exist");
        }
        this.response.setStatus(200);
        ResponseUtil.setRDFXMLContentType(this.response);
        PrintWriter out = new PrintWriter((OutputStream)this.response.getOutputStream());
        rdfObject.serializeAsRDF(out);
        this.response.flushBuffer();
    }

    @Override
    protected boolean canServe(Format format) {
        return format == Format.RDF;
    }
}

