/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.webservice.server.idresolution;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.intermine.api.InterMineAPI;
import org.intermine.api.bag.BagQueryResult;
import org.intermine.api.bag.ConvertedObjectPair;
import org.intermine.api.idresolution.Job;
import org.intermine.api.util.PathUtil;
import org.intermine.metadata.ClassDescriptor;
import org.intermine.metadata.Model;
import org.intermine.model.InterMineObject;
import org.intermine.objectstore.ObjectStoreException;
import org.intermine.pathquery.Path;
import org.intermine.pathquery.PathException;
import org.intermine.util.DynamicUtil;
import org.intermine.web.context.InterMineContext;
import org.intermine.web.logic.config.FieldConfig;
import org.intermine.web.logic.config.FieldConfigHelper;
import org.intermine.web.logic.config.WebConfig;
import org.intermine.webservice.server.idresolution.BagResultFormatter;

public class BagResultCategoryKeyFormatter
implements BagResultFormatter {
    private static final Logger LOG = Logger.getLogger(BagResultCategoryKeyFormatter.class);
    private static final String[] ISSUES = new String[]{"DUPLICATE", "WILDCARD", "OTHER", "TYPE_CONVERTED"};
    private final InterMineAPI im;

    public BagResultCategoryKeyFormatter(InterMineAPI api) {
        this.im = api;
    }

    @Override
    public Map<String, Object> format(Job job) {
        BagQueryResult bqr = job.getResult();
        String type = job.getType();
        HashMap<String, Object> ret = new HashMap<String, Object>();
        ret.put("matches", this.getMatchInfo(bqr));
        ret.put("unresolved", bqr.getUnresolvedIdentifiers());
        ret.put("stats", BagResultCategoryKeyFormatter.getStats(bqr));
        ret.put("type", type);
        return ret;
    }

    private Map<String, Object> getMatchInfo(BagQueryResult bqr) {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        ret.put("MATCH", this.getMatches(bqr));
        for (String issue : ISSUES) {
            ret.put(issue, this.getIssues(issue, bqr));
        }
        return ret;
    }

    private static Map<String, Map<String, Integer>> getStats(BagQueryResult bqr) {
        HashMap<String, Map<String, Integer>> stats = new HashMap<String, Map<String, Integer>>();
        HashMap<String, Integer> objectStats = new HashMap<String, Integer>();
        HashMap<String, Integer> termStats = new HashMap<String, Integer>();
        HashSet goodMatchTerms = new HashSet();
        HashSet<String> issueMatchTerms = new HashSet<String>();
        Set matchedObjects = bqr.getMatches().keySet();
        Set allMatchedObjects = bqr.getMatchAndIssueIds();
        for (List inputTerms : bqr.getMatches().values()) {
            goodMatchTerms.addAll(inputTerms);
        }
        for (String issue : ISSUES) {
            for (BagQueryResult.IssueResult ir : bqr.getIssueResults(issue)) {
                issueMatchTerms.add(ir.getInputIdent());
            }
        }
        int notFound = bqr.getUnresolvedIdentifiers().size();
        termStats.put("matches", goodMatchTerms.size());
        termStats.put("issues", issueMatchTerms.size());
        goodMatchTerms.addAll(issueMatchTerms);
        termStats.put("all", notFound + goodMatchTerms.size());
        termStats.put("notFound", notFound);
        objectStats.put("matches", matchedObjects.size());
        objectStats.put("all", allMatchedObjects.size());
        allMatchedObjects.removeAll(matchedObjects);
        objectStats.put("issues", allMatchedObjects.size());
        stats.put("objects", objectStats);
        stats.put("identifiers", termStats);
        return stats;
    }

    private List<Map<String, Object>> getIssues(String issueType, BagQueryResult bqr) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        for (BagQueryResult.IssueResult issue : bqr.getIssueResults(issueType)) {
            HashMap<String, Object> obj = new HashMap<String, Object>();
            ArrayList<Map<String, Object>> matches = new ArrayList<Map<String, Object>>();
            obj.put("input", issue.getInputIdent());
            obj.put("reason", issue.getQueryDesc());
            obj.put("matches", matches);
            for (Object match : issue.getResults()) {
                matches.add(this.processIssueMatch(match));
            }
            result.add(obj);
        }
        return result;
    }

    private Map<String, Object> processIssueMatch(Object match) {
        Map<String, Object> matchObj;
        if (match == null) {
            throw new IllegalStateException("null match returned.");
        }
        if (match instanceof Integer) {
            matchObj = this.processMatch((Integer)match);
        } else if (match instanceof InterMineObject) {
            matchObj = this.processMatch((InterMineObject)match);
        } else if (match instanceof ConvertedObjectPair) {
            matchObj = this.processMatch((ConvertedObjectPair)match);
        } else {
            throw new IllegalStateException("Cannot process " + match);
        }
        return matchObj;
    }

    private Map<String, Object> processMatch(Integer id) {
        HashMap<String, Object> matchObj = new HashMap<String, Object>();
        matchObj.put("id", id);
        matchObj.put("summary", this.getObjectDetails(id));
        return matchObj;
    }

    private Map<String, Object> processMatch(InterMineObject imo) {
        HashMap<String, Object> matchObj = new HashMap<String, Object>();
        matchObj.put("id", imo.getId());
        matchObj.put("summary", this.getObjectDetails(imo));
        return matchObj;
    }

    private Map<String, Object> processMatch(ConvertedObjectPair pair) {
        Map<String, Object> matchObj = this.processMatch(pair.getNewObject());
        Map<String, Object> from = this.processMatch(pair.getOldObject());
        matchObj.put("from", from);
        return matchObj;
    }

    private List<Map<String, Object>> getMatches(BagQueryResult bqr) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        for (Map.Entry match : bqr.getMatches().entrySet()) {
            HashMap<String, Object> obj = new HashMap<String, Object>();
            obj.put("id", match.getKey());
            obj.put("input", match.getValue());
            obj.put("summary", this.getObjectDetails((Integer)match.getKey()));
            result.add(obj);
        }
        return result;
    }

    private Map<String, Object> getObjectDetails(Integer objId) {
        InterMineObject imo;
        if (objId == null) {
            throw new IllegalArgumentException("obj cannot be null");
        }
        try {
            imo = this.im.getObjectStore().getObjectById(objId);
        }
        catch (ObjectStoreException e) {
            throw new IllegalStateException("Could not retrieve object reported as match", e);
        }
        return this.getObjectDetails(imo);
    }

    private Map<String, Object> getObjectDetails(InterMineObject imo) {
        WebConfig webConfig = InterMineContext.getWebConfig();
        Model m = this.im.getModel();
        HashMap<String, Object> objectDetails = new HashMap<String, Object>();
        String className = DynamicUtil.getSimpleClassName(imo.getClass());
        ClassDescriptor cd = m.getClassDescriptorByName(className);
        objectDetails.put("class", cd.getUnqualifiedName());
        for (FieldConfig fc : FieldConfigHelper.getClassFieldConfigs(webConfig, cd)) {
            try {
                Path p = new Path(m, cd.getUnqualifiedName() + "." + fc.getFieldExpr());
                if (!p.endIsAttribute() || !fc.getShowInSummary()) continue;
                objectDetails.put(p.getNoConstraintsString().replaceAll("^[^.]*\\.", ""), PathUtil.resolvePath((Path)p, (Object)imo));
            }
            catch (PathException e) {
                LOG.error((Object)"Configuration error", (Throwable)e);
            }
        }
        return objectDetails;
    }
}

