/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.webservice.server.idresolution;

import java.io.IOException;
import java.io.Reader;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.intermine.api.InterMineAPI;
import org.intermine.api.bag.BagQueryRunner;
import org.intermine.api.idresolution.IDResolver;
import org.intermine.api.idresolution.Job;
import org.intermine.api.idresolution.JobInput;
import org.intermine.webservice.server.core.JSONService;
import org.intermine.webservice.server.exceptions.BadRequestException;
import org.intermine.webservice.server.exceptions.ServiceException;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

public class IdResolutionService
extends JSONService {
    public IdResolutionService(InterMineAPI im) {
        super(im);
    }

    @Override
    protected void execute() throws Exception {
        WebserviceJobInput in;
        try {
            in = new WebserviceJobInput();
        }
        catch (JSONException e) {
            throw new BadRequestException("Invalid JSON object", e);
        }
        catch (IOException e) {
            throw new ServiceException("Could not read details", e);
        }
        BagQueryRunner runner = this.im.getBagQueryRunner();
        Job job = IDResolver.getInstance().submit(runner, (JobInput)in);
        this.addResultValue(job.getUid(), false);
    }

    @Override
    protected String getResultsKey() {
        return "uid";
    }

    private class WebserviceJobInput
    implements JobInput {
        private final List<String> ids;
        private final String extraValue;
        private final String type;
        private final Boolean caseSensitive;
        private final Boolean wildCards;
        private final Boolean ignoreConfig;

        WebserviceJobInput() throws JSONException, IOException {
            JSONObject requestDetails = new JSONObject(new JSONTokener((Reader)IdResolutionService.this.request.getReader()));
            JSONArray identifiers = requestDetails.getJSONArray("identifiers");
            this.ids = new LinkedList<String>();
            for (int i = 0; i < identifiers.length(); ++i) {
                this.ids.add(identifiers.getString(i));
            }
            this.type = requestDetails.getString("type");
            this.caseSensitive = requestDetails.optBoolean("caseSensitive", false);
            this.wildCards = requestDetails.optBoolean("wildCards", false);
            this.extraValue = requestDetails.optString("extra", null);
            this.ignoreConfig = requestDetails.optBoolean("ignoreConfig", false);
        }

        public List<String> getIds() {
            return this.ids;
        }

        public String getExtraValue() {
            return this.extraValue;
        }

        public String getType() {
            return this.type;
        }

        public Boolean getCaseSensitive() {
            return this.caseSensitive;
        }

        public Boolean getWildCards() {
            return this.wildCards;
        }

        public Boolean getIgnoreConfig() {
            return this.ignoreConfig;
        }

        public int hashCode() {
            return HashCodeBuilder.reflectionHashCode((Object)this);
        }

        public boolean equals(Object obj) {
            return EqualsBuilder.reflectionEquals((Object)this, (Object)obj);
        }
    }
}

