/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.webservice.server.idresolution;

import java.io.IOException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.intermine.webservice.server.WebService;
import org.intermine.webservice.server.core.JSONService;
import org.intermine.webservice.server.core.NoServiceException;
import org.intermine.webservice.server.core.WebServiceServlet;
import org.intermine.webservice.server.idresolution.IdResolutionService;
import org.intermine.webservice.server.idresolution.JobJanitor;
import org.intermine.webservice.server.idresolution.JobRemovalService;
import org.intermine.webservice.server.idresolution.JobResultsService;
import org.intermine.webservice.server.idresolution.JobStatusService;

public class IdResolutionServlet
extends WebServiceServlet {
    private static final Logger LOG = Logger.getLogger(IdResolutionServlet.class);
    private static final long serialVersionUID = -3364780354450369691L;
    private JobJanitor janitor = null;
    private Thread janitorThread = null;

    public void init(ServletConfig config) {
        try {
            this.janitor = new JobJanitor();
            this.janitorThread = new Thread(this.janitor);
            this.janitorThread.setDaemon(true);
            this.janitorThread.start();
        }
        catch (Exception e) {
            LOG.warn((Object)e);
        }
    }

    public void destroy() {
        if (this.janitor != null) {
            this.janitor.stop();
        }
        if (this.janitorThread != null) {
            this.janitorThread.interrupt();
        }
        super.destroy();
    }

    @Override
    protected void respond(WebServiceServlet.Method method, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        WebService getter;
        String[] uidAndCommand;
        if (WebServiceServlet.Method.GET == method && (uidAndCommand = IdResolutionServlet.getUidAndCommand(request)) != null && (getter = this.getGetter(uidAndCommand[0], uidAndCommand[1])) != null) {
            getter.service(request, response);
            return;
        }
        super.respond(method, request, response);
    }

    private static String[] getUidAndCommand(HttpServletRequest request) {
        String pathInfo = StringUtils.defaultString((String)request.getPathInfo(), (String)"").replaceAll("^/", "");
        int slashIndex = pathInfo.indexOf(47);
        if (slashIndex > 0) {
            String jobId = pathInfo.substring(0, slashIndex);
            String command = pathInfo.substring(slashIndex + 1);
            return new String[]{jobId, command};
        }
        return null;
    }

    private WebService getGetter(String uid, String command) {
        JSONService ws = null;
        if ("status".equalsIgnoreCase(command)) {
            ws = new JobStatusService(this.api, uid);
        } else if ("result".equalsIgnoreCase(command) || "results".equalsIgnoreCase(command)) {
            ws = new JobResultsService(this.api, uid);
        }
        return ws;
    }

    @Override
    protected WebService getService(WebServiceServlet.Method method) throws NoServiceException {
        switch (method) {
            case POST: {
                return new IdResolutionService(this.api);
            }
            case DELETE: {
                return new JobRemovalService(this.api);
            }
        }
        throw new NoServiceException();
    }
}

