/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.webservice.server.idresolution;

import java.util.Date;
import java.util.Iterator;
import org.apache.commons.lang.time.DateUtils;
import org.intermine.api.idresolution.IDResolver;
import org.intermine.api.idresolution.Job;

public class JobJanitor
implements Runnable {
    private static final long PERIOD = 60000L;
    private volatile boolean canContinue = true;

    @Override
    public void run() {
        IDResolver idresolver = IDResolver.getInstance();
        while (this.canContinue) {
            Iterator jobs = idresolver.getJobs().values().iterator();
            Date cutOff = DateUtils.addHours((Date)new Date(), (int)-3);
            block6: while (jobs.hasNext()) {
                if (Thread.interrupted()) {
                    return;
                }
                Job job = (Job)jobs.next();
                switch (job.getStatus()) {
                    case ERROR: 
                    case SUCCESS: {
                        Date startedAt = job.getStartedAt();
                        if (startedAt == null || !startedAt.before(cutOff)) continue block6;
                        jobs.remove();
                        continue block6;
                    }
                }
            }
            try {
                Thread.sleep(60000L);
            }
            catch (InterruptedException e) {
                return;
            }
        }
    }

    public void stop() {
        this.canContinue = false;
    }
}

