/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.webservice.server.idresolution;

import org.intermine.api.InterMineAPI;
import org.intermine.api.idresolution.IDResolver;
import org.intermine.api.idresolution.Job;
import org.intermine.webservice.server.core.JSONService;
import org.intermine.webservice.server.exceptions.ResourceNotFoundException;

public class JobStatusService
extends JSONService {
    private final String jobId;

    public JobStatusService(InterMineAPI im, String jobId) {
        super(im);
        this.jobId = jobId;
    }

    @Override
    protected void execute() throws Exception {
        Job job = IDResolver.getInstance().getJobById(this.jobId);
        if (job != null) {
            if (job.getStatus() == Job.JobStatus.ERROR) {
                this.addOutputInfo("message", job.getError().getMessage());
            }
        } else {
            throw new ResourceNotFoundException("No such job: " + this.jobId);
        }
        this.addResultValue(job.getStatus().name(), false);
    }

    @Override
    protected String getResultsKey() {
        return "status";
    }
}

