/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.webservice.server.idresolution;

import org.intermine.api.InterMineAPI;
import org.intermine.api.bag.BagQueryRunner;
import org.intermine.api.bag.BagQueryUpgrade;
import org.intermine.api.idresolution.IDResolver;
import org.intermine.api.idresolution.Job;
import org.intermine.api.profile.InterMineBag;
import org.intermine.api.profile.Profile;
import org.intermine.webservice.server.core.JSONService;
import org.intermine.webservice.server.exceptions.ResourceNotFoundException;

public class ListResolutionService
extends JSONService {
    public ListResolutionService(InterMineAPI im) {
        super(im);
    }

    @Override
    protected void execute() throws Exception {
        Profile profile = this.getPermission().getProfile();
        String listName = this.getRequiredParameter("name");
        InterMineBag savedBag = (InterMineBag)profile.getSavedBags().get(listName);
        if (savedBag == null) {
            throw new ResourceNotFoundException(listName + " doesn't exists");
        }
        BagQueryRunner runner = this.im.getBagQueryRunner();
        BagQueryUpgrade bagQueryUpgrade = new BagQueryUpgrade(runner, savedBag);
        Job job = IDResolver.getInstance().submit(bagQueryUpgrade);
        this.addResultValue(job.getUid(), false);
    }

    @Override
    protected String getResultsKey() {
        return "uid";
    }
}

