/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.webservice.server.lists;

import java.util.ArrayList;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.intermine.api.bag.BagManager;
import org.intermine.api.profile.InterMineBag;
import org.intermine.api.profile.Profile;
import org.intermine.webservice.server.exceptions.BadRequestException;
import org.intermine.webservice.server.lists.ListInput;

public class AsymmetricOperationInput
extends ListInput {
    public AsymmetricOperationInput(HttpServletRequest request, BagManager bagManager, Profile profile) {
        super(request, bagManager, profile);
    }

    @Override
    public Set<InterMineBag> getLists() {
        if (!this.getSubtractLists().isEmpty()) {
            return this.getSubtractLists();
        }
        return super.getLists();
    }

    @Override
    protected void validateRequiredParams() {
        super.validateRequiredParams();
        ArrayList<String> errors = new ArrayList<String>();
        if (this.getLists().isEmpty()) {
            errors.add("Both 'lists' and 'subtract' are missing, at least one is required");
        }
        if (!this.getSubtractLists().isEmpty() && !super.getLists().isEmpty()) {
            errors.add("Values have been supplied for both 'lists' and 'subtract'. At most one is permitted");
        }
        if (this.getReferenceLists().isEmpty()) {
            errors.add("Required parameter 'references' is missing");
        }
        if (!errors.isEmpty()) {
            String message = StringUtils.join(errors, (String)", ");
            throw new BadRequestException(message + ". PARAMS:" + this.request.getQueryString());
        }
    }
}

