/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.webservice.server.lists;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.intermine.api.InterMineAPI;
import org.intermine.api.bag.BagManager;
import org.intermine.api.profile.InterMineBag;
import org.intermine.api.profile.Profile;
import org.intermine.api.userprofile.Tag;
import org.intermine.objectstore.ObjectStoreException;
import org.intermine.webservice.server.exceptions.ServiceException;
import org.intermine.webservice.server.lists.ListFormatter;
import org.json.JSONObject;

public class JSONListFormatter
implements ListFormatter {
    private final InterMineAPI im;
    private final Profile profile;
    private int rowsLeft = 0;
    private final SimpleDateFormat iso8601 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");

    public JSONListFormatter(InterMineAPI im, Profile profile, boolean jsDates) {
        this.im = im;
        this.profile = profile;
    }

    Map<String, Object> bagToMap(InterMineBag list) {
        HashMap<String, Object> listMap = new HashMap<String, Object>();
        listMap.put("id", list.getSavedBagId());
        listMap.put("name", list.getName());
        listMap.put("type", list.getType());
        listMap.put("title", list.getTitle());
        listMap.put("description", list.getDescription());
        listMap.put("status", list.getState());
        if (list.getDateCreated() != null) {
            Date createdOn = list.getDateCreated();
            listMap.put("timestamp", createdOn.getTime());
            listMap.put("dateCreated", this.iso8601.format(createdOn));
        }
        BagManager bm = this.im.getBagManager();
        List tags = bm.getTagsForBag(list, this.profile);
        ArrayList<String> tagNames = new ArrayList<String>();
        for (Tag t : tags) {
            tagNames.add(t.getTagName());
        }
        listMap.put("tags", tagNames);
        try {
            listMap.put("size", list.getSize());
        }
        catch (ObjectStoreException e) {
            throw new ServiceException("Error getting list size:" + (Object)((Object)e));
        }
        boolean belongsToMe = list == this.profile.getSavedBags().get(list.getName());
        listMap.put("authorized", belongsToMe);
        return listMap;
    }

    @Override
    public List<String> format(InterMineBag list) {
        --this.rowsLeft;
        JSONObject listObj = new JSONObject(this.bagToMap(list));
        String ret = listObj.toString();
        if (this.rowsLeft > 0) {
            return Arrays.asList(ret, "");
        }
        return Arrays.asList(ret);
    }

    @Override
    public void setSize(int size) {
        this.rowsLeft = size;
    }
}

