/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.webservice.server.lists;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.ListUtils;
import org.intermine.api.InterMineAPI;
import org.intermine.api.profile.InterMineBag;
import org.intermine.webservice.server.Format;
import org.intermine.webservice.server.WebService;
import org.intermine.webservice.server.core.ListManager;
import org.intermine.webservice.server.exceptions.BadRequestException;

public class JaccardIndexService
extends WebService {
    public JaccardIndexService(InterMineAPI im) {
        super(im);
    }

    @Override
    protected void execute() throws Exception {
        String listName = this.request.getParameter("list");
        String ids = this.request.getParameter("ids");
        String min = this.request.getParameter("min");
        String type = this.request.getParameter("type");
        BigDecimal minimumValue = new BigDecimal(0);
        if (listName == null && ids == null) {
            throw new BadRequestException("Provide either name of a list or set of InterMine IDs");
        }
        if (min != null) {
            try {
                minimumValue = new BigDecimal(min);
            }
            catch (NumberFormatException e) {
                throw new BadRequestException("Min must be a valid number: '" + min + "'");
            }
        }
        ListManager listManager = new ListManager(this.im, this.getPermission().getProfile());
        Map<String, InterMineBag> lists = listManager.getListMap();
        List<Integer> bagOfInterest = new ArrayList();
        if (listName != null) {
            InterMineBag bag = lists.get(listName);
            if (bag == null) {
                throw new BadRequestException("User does not have access to list named '" + listName + "'");
            }
            bagOfInterest = bag.getContentsAsIds();
            type = bag.getType();
        } else if (ids != null) {
            if (type == null) {
                throw new BadRequestException("Type of list is required");
            }
            String[] idArray = ids.split("[, ]+");
            for (int i = 0; i < idArray.length; ++i) {
                bagOfInterest.add(Integer.parseInt(idArray[i]));
            }
        }
        HashMap<String, BigDecimal> results = new HashMap<String, BigDecimal>();
        this.output.setHeaderAttributes(this.getHeaderAttributes());
        for (Map.Entry<String, InterMineBag> entry : lists.entrySet()) {
            String name = entry.getKey();
            InterMineBag bag = entry.getValue();
            if (bag == null || listName != null && listName.equals(name) || !bag.getType().equalsIgnoreCase(type)) continue;
            List list = bag.getContentsAsIds();
            List intersection = ListUtils.intersection(bagOfInterest, (List)list);
            BigDecimal denominator = new BigDecimal(bagOfInterest.size() + list.size() - intersection.size());
            BigDecimal numerator = new BigDecimal(intersection.size());
            BigDecimal jaccardSimilarity = new BigDecimal(0);
            if (denominator.compareTo(BigDecimal.ZERO) != 0 && numerator.compareTo(BigDecimal.ZERO) != 0) {
                jaccardSimilarity = numerator.divide(denominator, 4, RoundingMode.HALF_EVEN);
            }
            if (jaccardSimilarity.compareTo(minimumValue) < 0) continue;
            results.put(name, jaccardSimilarity);
        }
        Map<String, BigDecimal> sortedMap = JaccardIndexService.sortByValue(results);
        ObjectMapper mapper = new ObjectMapper();
        ArrayNode rootNode = mapper.createArrayNode();
        for (Map.Entry entry : sortedMap.entrySet()) {
            ObjectNode childNode = mapper.createObjectNode();
            childNode.put((String)entry.getKey(), ((BigDecimal)entry.getValue()).toString());
            rootNode.add((JsonNode)childNode);
        }
        String jsonString = mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)rootNode);
        this.output.addResultItem(Collections.singletonList(jsonString));
    }

    protected Map<String, InterMineBag> getLists() {
        ListManager listManager = new ListManager(this.im, this.getPermission().getProfile());
        return listManager.getListMap();
    }

    @Override
    protected Format getDefaultFormat() {
        return Format.JSON;
    }

    @Override
    protected boolean canServe(Format format) {
        return format == Format.JSON || format == Format.HTML || format == Format.TEXT;
    }

    private Map<String, Object> getHeaderAttributes() {
        String listName = this.request.getParameter("list");
        String ids = this.request.getParameter("ids");
        String listOfInterestLabel = listName != null ? listName : "[" + ids + "]";
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        if (this.formatIsJSON()) {
            String inputLabel = "\"input\": \"" + listOfInterestLabel + "\",";
            attributes.put("intro", inputLabel + "\"results\":");
        }
        if (this.formatIsJSONP()) {
            attributes.put("callback", this.getCallback());
        } else if (this.getFormat() == Format.HTML) {
            attributes.put("headers", Arrays.asList("Name", "JaccardIndex"));
        }
        return attributes;
    }

    private static Map<String, BigDecimal> sortByValue(Map<String, BigDecimal> map) {
        ArrayList<Map.Entry<String, BigDecimal>> list = new ArrayList<Map.Entry<String, BigDecimal>>(map.entrySet());
        list.sort(Map.Entry.comparingByValue(new ResultsComparator()));
        LinkedHashMap<String, BigDecimal> result = new LinkedHashMap<String, BigDecimal>();
        for (Map.Entry entry : list) {
            result.put((String)entry.getKey(), (BigDecimal)entry.getValue());
        }
        return result;
    }

    private static class ResultsComparator
    implements Comparator {
        private ResultsComparator() {
        }

        public int compare(Object o1, Object o2) {
            BigDecimal d1 = (BigDecimal)o1;
            BigDecimal d2 = (BigDecimal)o2;
            if (d1.compareTo(d2) == 0) {
                return 0;
            }
            if (d1.compareTo(d2) > 0) {
                return -1;
            }
            return 1;
        }
    }
}

