/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.webservice.server.lists;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.intermine.api.bag.BagManager;
import org.intermine.api.bag.ClassKeysNotFoundException;
import org.intermine.api.bag.UnknownBagTypeException;
import org.intermine.api.profile.BagDoesNotExistException;
import org.intermine.api.profile.InterMineBag;
import org.intermine.api.profile.Profile;
import org.intermine.metadata.ClassDescriptor;
import org.intermine.metadata.DescriptorUtils;
import org.intermine.metadata.FieldDescriptor;
import org.intermine.metadata.MetaDataException;
import org.intermine.metadata.Model;
import org.intermine.objectstore.ObjectStoreException;
import org.intermine.webservice.server.exceptions.BadRequestException;
import org.intermine.webservice.server.exceptions.ServiceForbiddenException;

public final class ListServiceUtils {
    private ListServiceUtils() {
    }

    public static Collection<InterMineBag> castBagsToCommonType(Collection<InterMineBag> bags, String type, Set<String> nameAccumulator, Profile profile, Map<String, List<FieldDescriptor>> classKeys) throws UnknownBagTypeException, ClassKeysNotFoundException, ObjectStoreException {
        return bags;
    }

    public static void getBagsAndClasses(Set<ClassDescriptor> classes, Set<InterMineBag> lists, Profile profile, BagManager manager, Model model, String[] listNames) {
        for (String listName : listNames) {
            InterMineBag bag = manager.getBag(profile, listName);
            if (bag == null) {
                throw new ServiceForbiddenException(listName + " is not a list you have access to");
            }
            classes.add(model.getClassDescriptorByName(bag.getType()));
            lists.add(bag);
        }
    }

    public static void ensureBagIsDeleted(Profile profile, String name) throws ObjectStoreException {
        try {
            profile.deleteBag(name);
        }
        catch (BagDoesNotExistException bagDoesNotExistException) {
            // empty catch block
        }
    }

    public static String findCommonSuperTypeOf(Set<ClassDescriptor> classes) {
        try {
            return DescriptorUtils.findSumType(classes).getUnqualifiedName();
        }
        catch (MetaDataException e) {
            throw new BadRequestException(e.getMessage(), e);
        }
    }

    public static String findMostSpecificCommonTypeOf(Set<ClassDescriptor> classes) {
        try {
            return DescriptorUtils.findIntersectionType(classes).getUnqualifiedName();
        }
        catch (MetaDataException e) {
            throw new BadRequestException(e.getMessage(), e);
        }
    }

    public static List<ClassDescriptor> findCommonClasses(Set<ClassDescriptor> classes) {
        try {
            return DescriptorUtils.findCommonClasses(classes);
        }
        catch (MetaDataException e) {
            throw new BadRequestException(e.getMessage(), e);
        }
    }
}

