/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.webservice.server.lists;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.intermine.api.InterMineAPI;
import org.intermine.api.bag.SharedBagManager;
import org.intermine.api.profile.InterMineBag;
import org.intermine.api.profile.Profile;
import org.intermine.api.profile.ProfileManager;
import org.intermine.api.profile.StorableBag;
import org.intermine.api.profile.UserAlreadyShareBagException;
import org.intermine.util.Emailer;
import org.intermine.web.context.InterMineContext;
import org.intermine.web.context.MailAction;
import org.intermine.webservice.server.core.JSONService;
import org.intermine.webservice.server.exceptions.BadRequestException;
import org.intermine.webservice.server.exceptions.ResourceNotFoundException;
import org.intermine.webservice.server.exceptions.ServiceForbiddenException;

public class ListShareCreationService
extends JSONService {
    private static final Logger LOG = Logger.getLogger(ListShareCreationService.class);
    private final ProfileManager pm;
    private final SharedBagManager sbm;

    public ListShareCreationService(InterMineAPI im) {
        super(im);
        this.pm = im.getProfileManager();
        this.sbm = SharedBagManager.getInstance((ProfileManager)this.pm);
    }

    @Override
    public String getResultsKey() {
        return "share";
    }

    @Override
    protected void execute() throws Exception {
        InformUserOfNewShare action;
        UserInput input = new UserInput();
        try {
            this.sbm.shareBagWithUser(input.bag, input.recipient.getUsername());
        }
        catch (UserAlreadyShareBagException e) {
            throw new BadRequestException("This bag is already shared with this user", e);
        }
        HashMap<String, Set> data = new HashMap<String, Set>();
        data.put(input.bag.getName(), this.sbm.getUsersWithAccessToBag((StorableBag)input.bag));
        if (input.notify.booleanValue() && !input.recipient.prefers("do_not_spam") && !InterMineContext.queueMessage(action = new InformUserOfNewShare(input.recipient.getEmailAddress(), input.owner, input.bag))) {
            LOG.error((Object)"Could not send email message");
        }
        this.addResultItem(data, false);
    }

    private class InformUserOfNewShare
    implements MailAction {
        private final String to;
        private final Profile owner;
        private final InterMineBag bag;

        InformUserOfNewShare(String to, Profile owner, InterMineBag bag) {
            this.to = to;
            this.owner = owner;
            this.bag = bag;
        }

        @Override
        public void act(Emailer emailer) throws Exception {
            emailer.informUserOfNewSharedBag(this.to, this.owner, this.bag);
        }
    }

    private final class UserInput {
        private static final String CANT_SHARE_WITH_THEM = "The value of the 'with' parameter is not the name of user you can share lists with";
        private static final String NOT_YOUR_LIST = "The value of the 'list' parameter is not the name of a list you own";
        final Profile owner;
        final Profile recipient;
        final InterMineBag bag;
        final Boolean notify;

        UserInput() {
            this.owner = ListShareCreationService.this.getPermission().getProfile();
            if (!this.owner.isLoggedIn()) {
                throw new ServiceForbiddenException("Not authenticated.");
            }
            Map bags = this.owner.getSavedBags();
            if (bags.isEmpty()) {
                throw new BadRequestException("You do not have any lists to share");
            }
            String bagName = ListShareCreationService.this.getRequiredParameter("list");
            this.bag = (InterMineBag)bags.get(bagName);
            if (this.bag == null) {
                throw new ResourceNotFoundException(NOT_YOUR_LIST);
            }
            String recipientName = ListShareCreationService.this.getRequiredParameter("with");
            this.recipient = ListShareCreationService.this.pm.getProfile(recipientName);
            if (this.recipient == null || this.recipient.prefers("hidden")) {
                throw new ResourceNotFoundException(CANT_SHARE_WITH_THEM);
            }
            String notifyStr = ListShareCreationService.this.getOptionalParameter("notify", "false");
            this.notify = Boolean.parseBoolean(notifyStr);
        }
    }
}

