/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.webservice.server.lists;

import org.apache.commons.lang.StringUtils;
import org.intermine.api.InterMineAPI;
import org.intermine.api.bag.SharedBagManager;
import org.intermine.api.profile.InterMineBag;
import org.intermine.api.profile.Profile;
import org.intermine.api.profile.ProfileManager;
import org.intermine.api.profile.StorableBag;
import org.intermine.webservice.server.core.JSONService;
import org.intermine.webservice.server.exceptions.BadRequestException;
import org.intermine.webservice.server.exceptions.ResourceNotFoundException;
import org.intermine.webservice.server.exceptions.ServiceForbiddenException;

public class ListShareDeletionService
extends JSONService {
    private final ProfileManager pm;
    private final SharedBagManager sbm;

    public ListShareDeletionService(InterMineAPI im) {
        super(im);
        this.pm = im.getProfileManager();
        this.sbm = SharedBagManager.getInstance((ProfileManager)this.pm);
    }

    @Override
    protected void execute() throws Exception {
        UserInput input = new UserInput();
        if (input.bag != null && input.recipient != null) {
            this.sbm.unshareBagWithUser(input.bag, input.recipient.getName());
        } else if (input.recipient == null) {
            this.sbm.unshareBagWithAllUsers((StorableBag)input.bag);
        } else {
            this.sbm.unshareAllBagsFromUser(input.owner, input.recipient);
        }
    }

    private final class UserInput {
        final InterMineBag bag;
        final Profile owner;
        final Profile recipient;

        UserInput() {
            String recipientName;
            this.owner = ListShareDeletionService.this.getPermission().getProfile();
            if (!this.owner.isLoggedIn()) {
                throw new ServiceForbiddenException("Not authenticated.");
            }
            String bagName = ListShareDeletionService.this.request.getParameter("list");
            if (StringUtils.isBlank((String)bagName)) {
                throw new BadRequestException("Missing parameter: 'list'");
            }
            if (!"*".equals(bagName)) {
                this.bag = (InterMineBag)this.owner.getSavedBags().get(bagName);
                if (this.bag == null) {
                    throw new ResourceNotFoundException("The value of the 'list' parameter is not a list you own");
                }
            } else {
                this.bag = null;
            }
            if (StringUtils.isBlank((String)(recipientName = ListShareDeletionService.this.request.getParameter("with")))) {
                throw new BadRequestException("Missing parameter: 'with'");
            }
            if (!"*".equals(recipientName)) {
                this.recipient = ListShareDeletionService.this.pm.getProfile(recipientName);
                if (this.recipient == null) {
                    throw new ResourceNotFoundException("The value of the 'with' parameter is not a user in the data-base");
                }
            } else {
                this.recipient = null;
            }
            if (this.recipient == null && this.bag == null) {
                throw new BadRequestException("Too many wildcards");
            }
        }
    }
}

