/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.webservice.server.lists;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.intermine.api.InterMineAPI;
import org.intermine.api.bag.SharedBagManager;
import org.intermine.api.profile.InterMineBag;
import org.intermine.api.profile.Profile;
import org.intermine.api.profile.ProfileManager;
import org.intermine.api.profile.StorableBag;
import org.intermine.webservice.server.core.JSONService;
import org.intermine.webservice.server.exceptions.UnauthorizedException;

public class ListShareDetailsService
extends JSONService {
    private final SharedBagManager sbm;
    private final ProfileManager pm;

    public ListShareDetailsService(InterMineAPI im) {
        super(im);
        this.pm = im.getProfileManager();
        this.sbm = SharedBagManager.getInstance((ProfileManager)this.pm);
    }

    @Override
    protected void postInit() {
        super.postInit();
        if (!this.isAuthenticated()) {
            throw new UnauthorizedException("Users must authenticate.");
        }
    }

    @Override
    public String getResultsKey() {
        return "lists";
    }

    @Override
    protected void execute() throws Exception {
        Profile user = this.getPermission().getProfile();
        Map usersBags = user.getSavedBags();
        HashMap<String, Set> usersWhoCanAccessEachBag = new HashMap<String, Set>();
        for (Object bag : usersBags.values()) {
            usersWhoCanAccessEachBag.put(bag.getName(), this.sbm.getUsersWithAccessToBag((StorableBag)bag));
        }
        HashMap<String, String> ownersOfBagsSharedWithMe = new HashMap<String, String>();
        for (InterMineBag bag : user.getSharedBags().values()) {
            ownersOfBagsSharedWithMe.put(bag.getName(), this.pm.getProfileUserName(bag.getProfileId().intValue()));
        }
        HashMap<String, HashMap<String, Object>> data = new HashMap<String, HashMap<String, Object>>();
        data.put("sharedByUser", usersWhoCanAccessEachBag);
        data.put("sharedWithUser", ownersOfBagsSharedWithMe);
        this.addResultItem(data, false);
    }
}

