/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.webservice.server.lists;

import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.intermine.api.InterMineAPI;
import org.intermine.api.bag.SharedBagManager;
import org.intermine.api.bag.SharingInvite;
import org.intermine.api.profile.Profile;
import org.intermine.api.profile.ProfileManager;
import org.intermine.api.profile.UserAlreadyShareBagException;
import org.intermine.api.profile.UserNotFoundException;
import org.intermine.objectstore.ObjectStoreException;
import org.intermine.util.Emailer;
import org.intermine.web.context.InterMineContext;
import org.intermine.web.context.MailAction;
import org.intermine.webservice.server.core.JSONService;
import org.intermine.webservice.server.exceptions.BadRequestException;
import org.intermine.webservice.server.exceptions.ResourceNotFoundException;
import org.intermine.webservice.server.exceptions.ServiceException;
import org.intermine.webservice.server.exceptions.ServiceForbiddenException;
import org.intermine.webservice.server.lists.JSONListFormatter;

public class ListSharingInvitationAcceptanceService
extends JSONService {
    private static final Logger LOG = Logger.getLogger(ListSharingInvitationAcceptanceService.class);
    private static final Set<String> ACCEPTABLE_ACCEPTANCES = new HashSet<String>(Arrays.asList("true", "false"));
    private final SharedBagManager sbm;

    public ListSharingInvitationAcceptanceService(InterMineAPI im) {
        super(im);
        this.sbm = SharedBagManager.getInstance((ProfileManager)im.getProfileManager());
    }

    @Override
    protected String getResultsKey() {
        return "list";
    }

    @Override
    protected void execute() throws SharingInvite.NotFoundException {
        UserInput input = new UserInput();
        try {
            this.sbm.resolveInvitation(input.invite, input.accepter, input.accepted);
        }
        catch (UserNotFoundException e) {
            throw new ServiceException("Inconsistent state: p.isLoggedIn() but not found in DB");
        }
        catch (UserAlreadyShareBagException e) {
            LOG.warn((Object)"User accepted an invitation to a list they already have access to", (Throwable)e);
        }
        if (input.notify) {
            this.notifyOwner(input.invite);
        }
        if (input.accepted) {
            JSONListFormatter formatter = new JSONListFormatter(this.im, input.accepter, false);
            this.addResultItem(formatter.bagToMap(input.invite.getBag()), false);
        } else {
            this.addResultItem(new HashMap(), false);
        }
    }

    private void notifyOwner(final SharingInvite invite) {
        ProfileManager pm = this.im.getProfileManager();
        final Profile receiver = this.getPermission().getProfile();
        final Profile owner = pm.getProfile(invite.getBag().getProfileId().intValue());
        boolean queued = InterMineContext.queueMessage(new MailAction(){

            @Override
            public void act(Emailer emailer) throws Exception {
                emailer.email(owner.getEmailAddress(), "was-accepted", invite.getCreatedAt(), invite.getInvitee(), invite.getBag(), receiver.getUsername(), ListSharingInvitationAcceptanceService.this.webProperties.getProperty("project.title"));
            }
        });
        if (!queued) {
            LOG.error((Object)"Mail queue full, could not send message");
        }
    }

    private final class UserInput {
        private static final String NOT_ACCEPTABLE = "The value of the 'accepted' parameter must be one of ";
        final boolean accepted;
        final SharingInvite invite;
        final Profile accepter;
        final boolean notify;

        UserInput() {
            this.accepter = ListSharingInvitationAcceptanceService.this.getPermission().getProfile();
            if (!this.accepter.isLoggedIn()) {
                throw new ServiceForbiddenException("You must be logged in");
            }
            String pathInfo = ListSharingInvitationAcceptanceService.this.request.getPathInfo();
            String token = pathInfo != null && pathInfo.matches("/[^/]{20}") ? pathInfo.substring(1, 21) : ListSharingInvitationAcceptanceService.this.request.getParameter("uid");
            if (StringUtils.isBlank((String)token)) {
                throw new BadRequestException("Missing required parameter: 'uid'");
            }
            String isAccepted = ListSharingInvitationAcceptanceService.this.request.getParameter("accepted");
            if (StringUtils.isBlank((String)isAccepted)) {
                throw new BadRequestException("Missing required parameter: 'accepted'");
            }
            if (!ACCEPTABLE_ACCEPTANCES.contains(isAccepted.toLowerCase())) {
                throw new BadRequestException(NOT_ACCEPTABLE + ACCEPTABLE_ACCEPTANCES);
            }
            this.accepted = Boolean.parseBoolean(isAccepted);
            try {
                this.invite = SharingInvite.getByToken((InterMineAPI)ListSharingInvitationAcceptanceService.this.im, (String)token);
            }
            catch (SQLException e) {
                throw new ServiceException("Error retrieving invitation", e);
            }
            catch (ObjectStoreException e) {
                throw new ServiceException("Corrupt invitation", e);
            }
            catch (SharingInvite.NotFoundException e) {
                throw new ResourceNotFoundException("invitation does not exist", e);
            }
            if (this.invite == null) {
                throw new ResourceNotFoundException("Could not find invitation");
            }
            String sendEmail = ListSharingInvitationAcceptanceService.this.request.getParameter("notify");
            this.notify = StringUtils.isNotBlank((String)sendEmail) && "true".equalsIgnoreCase(sendEmail);
        }
    }
}

