/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.webservice.server.lists;

import java.sql.SQLException;
import org.apache.commons.lang.StringUtils;
import org.intermine.api.InterMineAPI;
import org.intermine.api.bag.SharedBagManager;
import org.intermine.api.bag.SharingInvite;
import org.intermine.api.profile.Profile;
import org.intermine.api.profile.ProfileManager;
import org.intermine.objectstore.ObjectStoreException;
import org.intermine.webservice.server.core.JSONService;
import org.intermine.webservice.server.exceptions.BadRequestException;
import org.intermine.webservice.server.exceptions.ResourceNotFoundException;
import org.intermine.webservice.server.exceptions.ServiceException;
import org.intermine.webservice.server.exceptions.ServiceForbiddenException;

public class ListSharingInvitationDeletionService
extends JSONService {
    private final SharedBagManager sbm;

    public ListSharingInvitationDeletionService(InterMineAPI im) {
        super(im);
        this.sbm = SharedBagManager.getInstance((ProfileManager)im.getProfileManager());
    }

    @Override
    protected void execute() throws Exception {
        UserInput input = new UserInput();
        try {
            input.invite.delete();
        }
        catch (SharingInvite.NotFoundException e) {
            throw new ResourceNotFoundException("Error deleting token.", e);
        }
    }

    private final class UserInput {
        final SharingInvite invite;
        final Profile accepter;

        UserInput() {
            this.accepter = ListSharingInvitationDeletionService.this.getPermission().getProfile();
            if (!this.accepter.isLoggedIn()) {
                throw new ServiceForbiddenException("You must be logged in");
            }
            String pathInfo = ListSharingInvitationDeletionService.this.request.getPathInfo();
            String token = pathInfo != null && pathInfo.matches("/[^/]{20}") ? pathInfo.substring(1, 21) : ListSharingInvitationDeletionService.this.request.getParameter("uid");
            if (StringUtils.isBlank((String)token)) {
                throw new BadRequestException("Missing required parameter: 'uid'");
            }
            try {
                this.invite = SharingInvite.getByToken((InterMineAPI)ListSharingInvitationDeletionService.this.im, (String)token);
            }
            catch (SQLException e) {
                throw new ServiceException("Error retrieving invitation", e);
            }
            catch (ObjectStoreException e) {
                throw new ServiceException("Corrupt invitation", e);
            }
            catch (SharingInvite.NotFoundException e) {
                throw new ResourceNotFoundException("invitation does not exist", e);
            }
            if (this.invite == null) {
                throw new ResourceNotFoundException("Could not find invitation");
            }
        }
    }
}

