/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.webservice.server.lists;

import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.intermine.api.InterMineAPI;
import org.intermine.api.bag.SharingInvite;
import org.intermine.api.profile.InterMineBag;
import org.intermine.api.profile.Profile;
import org.intermine.objectstore.ObjectStoreException;
import org.intermine.webservice.server.core.F;
import org.intermine.webservice.server.core.JSONService;
import org.intermine.webservice.server.core.ListFunctions;
import org.intermine.webservice.server.exceptions.ResourceNotFoundException;
import org.intermine.webservice.server.exceptions.ServiceForbiddenException;

public class ListSharingInvitationDetailsService
extends JSONService {
    public ListSharingInvitationDetailsService(InterMineAPI im) {
        super(im);
    }

    @Override
    protected Map<String, Object> getHeaderAttributes() {
        Map<String, Object> attrs = super.getHeaderAttributes();
        attrs.put("intro", "\"invitation\":");
        return attrs;
    }

    @Override
    protected void execute() throws Exception {
        Profile p = this.getPermission().getProfile();
        if (!p.isLoggedIn()) {
            throw new ServiceForbiddenException("You must be logged in to use this service");
        }
        String pathInfo = this.request.getPathInfo();
        String token = pathInfo != null && pathInfo.matches("/[^/]{20}") ? pathInfo.substring(1, 21) : this.request.getParameter("uid");
        if (StringUtils.isBlank((String)token)) {
            this.sendAllPending();
        } else {
            this.sendIndividual(token);
        }
    }

    private void sendAllPending() throws SQLException, ObjectStoreException {
        Profile inviter = this.getPermission().getProfile();
        Collection invites = SharingInvite.getInvites((InterMineAPI)this.im, (Profile)inviter);
        this.addResultItem(ListFunctions.map(invites, new F<SharingInvite, Object>(){

            @Override
            public Object call(SharingInvite a) {
                return ListSharingInvitationDetailsService.this.inviteToMap(a);
            }
        }), false);
    }

    private void sendIndividual(String token) throws SQLException, ObjectStoreException {
        SharingInvite invite;
        try {
            invite = SharingInvite.getByToken((InterMineAPI)this.im, (String)token);
        }
        catch (SharingInvite.NotFoundException e) {
            throw new ResourceNotFoundException(e.getMessage(), e);
        }
        Map<String, Object> toSerialise = this.inviteToMap(invite);
        this.addResultItem(toSerialise, false);
    }

    private Map<String, Object> inviteToMap(SharingInvite invite) {
        InterMineBag bag = invite.getBag();
        Profile inviter = this.im.getProfileManager().getProfile(bag.getProfileId().intValue());
        HashMap<String, Object> toSerialise = new HashMap<String, Object>();
        toSerialise.put("uid", invite.getToken());
        toSerialise.put("inviter", inviter.getName());
        toSerialise.put("list", bag.getName());
        toSerialise.put("invitee", invite.getInvitee());
        return toSerialise;
    }
}

