/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.webservice.server.lists;

import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.intermine.api.InterMineAPI;
import org.intermine.api.bag.SharedBagManager;
import org.intermine.api.bag.SharingInvite;
import org.intermine.api.profile.InterMineBag;
import org.intermine.api.profile.Profile;
import org.intermine.util.Emailer;
import org.intermine.web.context.InterMineContext;
import org.intermine.web.context.MailAction;
import org.intermine.webservice.server.core.JSONService;
import org.intermine.webservice.server.exceptions.ResourceNotFoundException;

public class ListSharingInvitationService
extends JSONService {
    private static final Logger LOG = Logger.getLogger(ListSharingInvitationService.class);
    private static final String EMAIL_PROPERTY = "sharing-invite";

    public ListSharingInvitationService(InterMineAPI im) {
        super(im);
    }

    @Override
    protected String getResultsKey() {
        return "invitation";
    }

    @Override
    protected void execute() {
        UserInput input = new UserInput();
        SharingInvite invite = SharedBagManager.inviteToShare((InterMineBag)input.bag, (String)input.invitee);
        this.addResultItem(this.marshallInvite(input, invite), false);
        if (input.notify) {
            this.notifyInvitee(input, invite);
        }
    }

    private Map<String, Object> marshallInvite(UserInput input, SharingInvite invite) {
        HashMap<String, Object> toSerialise = new HashMap<String, Object>();
        toSerialise.put("invite-token", invite.getToken());
        toSerialise.put("list", input.bag.getName());
        toSerialise.put("invitee", input.invitee);
        return toSerialise;
    }

    private void notifyInvitee(final UserInput input, final SharingInvite invite) {
        final InterMineBag bag = invite.getBag();
        boolean queued = InterMineContext.queueMessage(new MailAction(){

            @Override
            public void act(Emailer emailer) throws Exception {
                emailer.email(invite.getInvitee(), ListSharingInvitationService.EMAIL_PROPERTY, input.owner.getName(), bag.getType(), bag.getName(), bag.getSize(), ListSharingInvitationService.this.webProperties.getProperty("webapp.baseurl"), ListSharingInvitationService.this.webProperties.getProperty("webapp.path"), invite.getToken(), ListSharingInvitationService.this.webProperties.getProperty("project.title"));
            }
        });
        if (!queued) {
            LOG.error((Object)"Mail queue full, could not send message");
        }
    }

    private final class UserInput {
        final Profile owner;
        final InterMineBag bag;
        final String invitee;
        final boolean notify;

        UserInput() {
            this.owner = ListSharingInvitationService.this.getAuthenticatedUser();
            String bagName = ListSharingInvitationService.this.getRequiredParameter("list");
            this.bag = (InterMineBag)this.owner.getSavedBags().get(bagName);
            if (this.bag == null) {
                throw new ResourceNotFoundException("You do not own a list called " + bagName);
            }
            this.invitee = ListSharingInvitationService.this.getRequiredParameter("to");
            String sendEmail = ListSharingInvitationService.this.getOptionalParameter("notify", "false");
            this.notify = "true".equalsIgnoreCase(sendEmail) || "1".equals(sendEmail);
        }
    }
}

