/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.webservice.server.lists;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Transformer;
import org.apache.commons.collections.TransformerUtils;
import org.apache.commons.lang.StringUtils;
import org.intermine.api.InterMineAPI;
import org.intermine.api.bag.BagManager;
import org.intermine.api.profile.InterMineBag;
import org.intermine.api.profile.Profile;
import org.intermine.api.profile.TagManager;
import org.intermine.webservice.server.exceptions.BadRequestException;
import org.intermine.webservice.server.exceptions.ResourceNotFoundException;
import org.intermine.webservice.server.exceptions.ServiceForbiddenException;
import org.intermine.webservice.server.lists.ListTagService;

public class ListTagAddingService
extends ListTagService {
    private static final String TAGS = "tags";

    public ListTagAddingService(InterMineAPI im) {
        super(im);
    }

    @Override
    protected void execute() throws Exception {
        Profile profile;
        String listName = this.getRequiredParameter("name");
        Set<String> tags = this.getTags();
        BagManager bagManager = this.im.getBagManager();
        Map lists = bagManager.getUserBags(profile = this.getPermission().getProfile());
        InterMineBag list = (InterMineBag)lists.get(listName);
        if (list == null) {
            throw new ResourceNotFoundException("You do not have access to a list called " + listName);
        }
        this.modifyList(tags, list);
        List allTags = bagManager.getTagsForBag(list, this.getPermission().getProfile());
        List tagNames = (List)CollectionUtils.collect((Collection)allTags, (Transformer)TransformerUtils.invokerTransformer((String)"getTagName"));
        this.output.addResultItem(tagNames);
    }

    protected void modifyList(Set<String> tags, InterMineBag list) {
        Profile profile = this.getPermission().getProfile();
        try {
            this.bagManager.addTagsToBag(tags, list, profile);
        }
        catch (TagManager.TagNameException e) {
            throw new BadRequestException(e.getMessage());
        }
        catch (TagManager.TagNamePermissionException e) {
            throw new ServiceForbiddenException(e.getMessage());
        }
    }

    private Set<String> getTags() {
        String[] tagValues = this.request.getParameterValues(TAGS);
        if (tagValues == null) {
            throw new BadRequestException("No tags supplied");
        }
        HashSet<String> tags = new HashSet<String>();
        for (String tagValue : tagValues) {
            String[] subvalues = StringUtils.split((String)tagValue, (char)';');
            Collections.addAll(tags, subvalues);
        }
        return tags;
    }
}

