/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.webservice.server.lists;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Transformer;
import org.apache.commons.collections.TransformerUtils;
import org.intermine.api.InterMineAPI;
import org.intermine.api.bag.BagManager;
import org.intermine.api.profile.InterMineBag;
import org.intermine.api.profile.Profile;
import org.intermine.webservice.server.exceptions.ResourceNotFoundException;
import org.intermine.webservice.server.lists.AbstractListService;

public class ListTagService
extends AbstractListService {
    public ListTagService(InterMineAPI im) {
        super(im);
    }

    @Override
    protected Map<String, Object> getHeaderAttributes() {
        Map<String, Object> attributes = super.getHeaderAttributes();
        attributes.put("intro", "\"tags\":[");
        attributes.put("outro", "]");
        attributes.put("should_quote", true);
        return attributes;
    }

    @Override
    protected void execute() throws Exception {
        Profile profile = this.getPermission().getProfile();
        String listName = this.getOptionalParameter("name", null);
        Set<Object> tags = new HashSet();
        if (!"__ANONYMOUS_USER__".equals(profile.getUsername())) {
            tags = listName == null ? this.getAllTags(profile) : this.getTagsForSingleList(listName, profile);
        }
        this.output.addResultItem(new ArrayList<String>(tags));
    }

    private Set<String> getTagsForSingleList(String name, Profile profile) {
        BagManager bagManager = this.im.getBagManager();
        Map lists = bagManager.getBags(profile);
        InterMineBag list = (InterMineBag)lists.get(name);
        if (list == null) {
            throw new ResourceNotFoundException("You do not have access to a list called " + name);
        }
        List tags = bagManager.getTagsForBag(list, profile);
        Collection tagNames = CollectionUtils.collect((Collection)tags, (Transformer)TransformerUtils.invokerTransformer((String)"getTagName"));
        return new HashSet<String>(tagNames);
    }

    private Set<String> getAllTags(Profile profile) {
        return this.im.getTagManager().getUserTagNames("bag", profile);
    }
}

