/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.webservice.server.lists;

import java.util.Map;
import org.apache.log4j.Logger;
import org.intermine.api.InterMineAPI;
import org.intermine.api.profile.BagDoesNotExistException;
import org.intermine.api.profile.InterMineBag;
import org.intermine.api.profile.Profile;
import org.intermine.webservice.server.exceptions.BadRequestException;
import org.intermine.webservice.server.lists.AuthenticatedListService;

public class ListUpdateService
extends AuthenticatedListService {
    Map<String, String> parameters = null;
    private static final Logger LOG = Logger.getLogger(ListUpdateService.class);

    public ListUpdateService(InterMineAPI im) {
        super(im);
    }

    @Override
    protected void execute() throws Exception {
        String listName = this.getRequiredParameter("name");
        String newListDescription = this.request.getParameter("newDescription");
        Profile profile = this.getPermission().getProfile();
        try {
            profile.updateBagDescription(listName, newListDescription);
        }
        catch (BagDoesNotExistException ex) {
            throw new BadRequestException("The list " + listName + " does not belong to the user");
        }
        InterMineBag list = (InterMineBag)profile.getSavedBags().get(listName);
        this.addOutputInfo("name", list.getName());
        this.addOutputInfo("description", list.getDescription());
    }
}

