/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.webservice.server.lists;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.FileItemIterator;
import org.apache.commons.fileupload.FileItemStream;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.text.StrMatcher;
import org.apache.commons.lang.text.StrTokenizer;
import org.intermine.InterMineException;
import org.intermine.api.InterMineAPI;
import org.intermine.api.bag.BagQueryResult;
import org.intermine.api.bag.BagQueryRunner;
import org.intermine.api.profile.InterMineBag;
import org.intermine.api.profile.Profile;
import org.intermine.objectstore.ObjectStoreException;
import org.intermine.webservice.server.exceptions.BadRequestException;
import org.intermine.webservice.server.exceptions.ServiceException;
import org.intermine.webservice.server.lists.ListCreationInput;
import org.intermine.webservice.server.lists.ListInput;
import org.intermine.webservice.server.lists.ListMakerService;
import org.intermine.webservice.server.lists.ListServiceUtils;

public class ListUploadService
extends ListMakerService {
    public static final String USAGE = "\nList Upload Service\n===================\nUpload a new list, or overwrite an existing one\nParameters:\n* name: the name of the list\n* type: type of the list\n* description: A description of the list (optional)\n* extraValue: An extra field value to allow disambiguation(optional)\n* tags: a semi-colon delimited list of tags to tag the new list with\n\nContent: text/plain - list of ids\n";
    public static final int BAG_QUERY_MAX_BATCH_SIZE = 10000;
    private final BagQueryRunner runner;
    protected static final String PLAIN_TEXT = "text/plain";

    public ListUploadService(InterMineAPI im) {
        super(im);
        this.runner = im.getBagQueryRunner();
    }

    @Override
    protected Map<String, Object> getHeaderAttributes() {
        Map<String, Object> attributes = super.getHeaderAttributes();
        if (this.formatIsJSON()) {
            attributes.put("intro", "\"unmatchedIdentifiers\":[");
            attributes.put("outro", "]");
            attributes.put("should_quote", Boolean.TRUE);
        }
        return attributes;
    }

    protected void setListSize(Integer size) {
        this.addOutputInfo("listSize", size + "");
    }

    protected void setListId(Integer id) {
        this.addOutputInfo("listId", id + "");
    }

    protected StrMatcher getMatcher() {
        String bagUploadDelims = this.getProperty("list.upload.delimiters") + " ";
        StrMatcher matcher = StrMatcher.charSetMatcher((String)bagUploadDelims);
        return matcher;
    }

    @Override
    protected String getNewListType(ListInput input) {
        return input.getType();
    }

    @Override
    protected ListCreationInput getInput() {
        return new ListCreationInput(this.request, this.bagManager, this.getPermission().getProfile());
    }

    @Override
    protected void makeList(ListInput listInput, String type, Profile profile, Set<String> temporaryBagNamesAccumulator) throws Exception {
        if (StringUtils.isBlank((String)type)) {
            throw new BadRequestException("No list type provided");
        }
        ListCreationInput input = (ListCreationInput)listInput;
        if (input.doReplace()) {
            ListServiceUtils.ensureBagIsDeleted(profile, input.getListName());
        }
        if (profile.getAllBags().containsKey(input.getListName())) {
            throw new BadRequestException("Attempt to overwrite an existing bag - name: '" + input.getListName() + "'");
        }
        LinkedHashSet<String> ids = new LinkedHashSet<String>();
        HashSet<String> unmatchedIds = new HashSet<String>();
        InterMineBag tempBag = profile.createBag(input.getTemporaryListName(), type, input.getDescription(), (Map)this.im.getClassKeys());
        this.processIdentifiers(type, input, ids, unmatchedIds, tempBag);
        this.setListSize(tempBag.size());
        this.setListId(tempBag.getSavedBagId());
        Iterator i = unmatchedIds.iterator();
        while (i.hasNext()) {
            ArrayList<String> row = new ArrayList<String>(Arrays.asList((String)i.next()));
            if (i.hasNext()) {
                row.add("");
            }
            this.output.addResultItem(row);
        }
        if (!input.getTags().isEmpty()) {
            this.im.getBagManager().addTagsToBag(input.getTags(), tempBag, profile);
        }
        profile.renameBag(input.getTemporaryListName(), input.getListName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processIdentifiers(String type, ListCreationInput input, Set<String> ids, Set<String> unmatchedIds, InterMineBag tempBag) throws IOException, ClassNotFoundException, InterMineException, ObjectStoreException {
        Collection<String> addIssues = input.getAddIssues();
        StrMatcher matcher = this.getMatcher();
        try (BufferedReader r = this.getReader(this.request);){
            String line;
            while ((line = r.readLine()) != null) {
                StrTokenizer st = new StrTokenizer(line, matcher, StrMatcher.doubleQuoteMatcher());
                while (st.hasNext()) {
                    String token = st.nextToken();
                    ids.add(token);
                }
                if (ids.size() > 10000) continue;
                this.addIdsToList(ids, tempBag, type, input.getExtraValue(), unmatchedIds, addIssues);
                ids.clear();
            }
        }
        if (ids.size() > 0) {
            this.addIdsToList(ids, tempBag, type, input.getExtraValue(), unmatchedIds, addIssues);
        }
    }

    protected BufferedReader getReader(HttpServletRequest request) {
        BufferedReader r = null;
        if (ServletFileUpload.isMultipartContent((HttpServletRequest)request)) {
            ServletFileUpload upload = new ServletFileUpload();
            try {
                FileItemIterator iter = upload.getItemIterator(request);
                while (iter.hasNext()) {
                    FileItemStream item = iter.next();
                    String fieldName = item.getFieldName();
                    if (item.isFormField() || !"identifiers".equalsIgnoreCase(fieldName)) continue;
                    InputStream stream = item.openStream();
                    InputStreamReader in = new InputStreamReader(stream);
                    r = new BufferedReader(in);
                }
            }
            catch (FileUploadException e) {
                throw new ServiceException("Could not read request body", e);
            }
            catch (IOException e) {
                throw new ServiceException(e);
            }
        } else {
            if (!this.requestIsOfSuitableType()) {
                throw new BadRequestException("Bad content type - " + request.getContentType() + USAGE);
            }
            try {
                r = request.getReader();
            }
            catch (IOException e) {
                throw new ServiceException(e);
            }
        }
        if (r == null) {
            throw new BadRequestException("No identifiers found in request.\nList Upload Service\n===================\nUpload a new list, or overwrite an existing one\nParameters:\n* name: the name of the list\n* type: type of the list\n* description: A description of the list (optional)\n* extraValue: An extra field value to allow disambiguation(optional)\n* tags: a semi-colon delimited list of tags to tag the new list with\n\nContent: text/plain - list of ids\n");
        }
        return r;
    }

    protected boolean requestIsOfSuitableType() {
        String mimetype = this.request.getContentType();
        return "application/octet-stream".equals(mimetype) || mimetype.startsWith("text");
    }

    protected void addIdsToList(Collection<? extends String> ids, InterMineBag bag, String type, String extraFieldValue, Set<String> unmatchedIds, Collection<String> acceptableIssues) throws ClassNotFoundException, InterMineException, ObjectStoreException {
        BagQueryResult result = this.runner.searchForBag(type, new ArrayList<String>(ids), extraFieldValue, acceptableIssues.contains("WILDCARD"));
        bag.addIdsToBag(result.getMatches().keySet(), type);
        for (String issueType : result.getIssues().keySet()) {
            if (acceptableIssues.contains(issueType)) {
                bag.addIdsToBag((Collection)result.getIssueIds(issueType), type);
                continue;
            }
            unmatchedIds.addAll(result.getInputIdentifiersForIssue(issueType));
        }
        unmatchedIds.addAll(result.getUnresolvedIdentifiers());
    }
}

