/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.webservice.server.lists;

import javax.servlet.http.HttpServletRequest;
import org.intermine.webservice.server.exceptions.BadRequestException;
import org.intermine.webservice.server.lists.ListsServiceInput;

public class ListsRequestParser {
    private HttpServletRequest request;
    private static final String MINE_ID_PARAMETER = "id";
    private static final String PUBLIC_ID_PARAMETER = "publicId";
    public static final String TYPE_PARAMETER = "type";

    public ListsRequestParser(HttpServletRequest request) {
        this.request = request;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ListsServiceInput getInput() {
        ListsServiceInput ret = new ListsServiceInput();
        String publicId = this.request.getParameter(PUBLIC_ID_PARAMETER);
        String mineId = this.request.getParameter(MINE_ID_PARAMETER);
        if (publicId == null && mineId == null || publicId != null && mineId != null) {
            throw new BadRequestException("invalid parameters: id or publicId are required.");
        }
        if (publicId != null) {
            ret.setPublicId(publicId);
            String type = this.request.getParameter(TYPE_PARAMETER);
            if (type == null) throw new BadRequestException("missing parameter: type");
            ret.setType(type);
        } else {
            try {
                ret.setMineId(Integer.parseInt(mineId));
            }
            catch (Throwable t) {
                throw new BadRequestException("invalid parameter: id");
            }
        }
        ret.setExtraValue(this.request.getParameter("extraValue"));
        return ret;
    }
}

